/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.config.datasource;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.config.datasource.TestConnectionWindow;
import org.jboss.hal.testsuite.fragment.shared.modal.WizardWindow;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableFragment;
import org.jboss.hal.testsuite.fragment.shared.util.ResourceManager;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasourceWizard
extends WizardWindow {
    private static final Logger logger = LoggerFactory.getLogger(DatasourceWizard.class);
    private static final By DETECTED_DRIVER_BUTTON = By.xpath((String)".//div[text()='Detected Driver']");
    private static final Location ORIGIN_LOCATION = Location.TEMPLATE_SELECTION;
    private Location currentLocation = ORIGIN_LOCATION;

    public TestConnectionWindow testConnectionUnchecked() {
        String label = PropUtils.get("config.datasources.configarea.connection.test.label");
        this.clickButton(label);
        Console.withBrowser(this.browser).waitUntilFinished();
        String windowTitle = PropUtils.get("config.datasources.window.connection.test.head.label");
        return Console.withBrowser(this.browser).openedWindow(windowTitle, TestConnectionWindow.class);
    }

    public TestConnectionWindow testConnection() {
        this.checkIfCurrentLocationIsExpected(Location.TEST_CONNECTION);
        return this.testConnectionUnchecked();
    }

    public void switchToDetectedDriverUnchecked() {
        this.root.findElement(DETECTED_DRIVER_BUTTON).click();
    }

    public void switchToDetectedDriver() {
        this.checkIfCurrentLocationIsExpected(Location.JDBC_DRIVER);
        this.switchToDetectedDriverUnchecked();
    }

    public ResourceTableFragment getResourceTable() {
        return ((ResourceManager)Graphene.createPageFragment(ResourceManager.class, (WebElement)this.root)).getResourceTable();
    }

    public DatasourceWizard selectTemplateUnchecked(String templateLabel) {
        ByJQuery selectListItemSelector = ByJQuery.selector((String)(".choose_template:contains('" + templateLabel + "')"));
        this.getRoot().findElement((By)selectListItemSelector).findElement(By.tagName((String)"input")).click();
        return this;
    }

    public DatasourceWizard selectTemplate(String templateLabel) {
        this.checkIfCurrentLocationIsExpected(Location.TEMPLATE_SELECTION);
        return this.selectTemplateUnchecked(templateLabel);
    }

    public void selectDriverUnchecked(String driverName) {
        this.getResourceTable().selectRowByText(0, driverName);
    }

    public void selectDriver(String driverName) {
        this.checkIfCurrentLocationIsExpected(Location.JDBC_DRIVER);
        this.selectDriverUnchecked(driverName);
    }

    public DatasourceWizard goToLocation(Location newLocation, DatasourceType type) {
        int difference = newLocation.getIndex(type) - this.currentLocation.getIndex(type);
        logger.debug("Moving to '{}'.", (Object)newLocation.getName());
        if (difference == 0) {
            logger.debug("Already at desired location.");
            return this;
        }
        if (difference < 0) {
            logger.debug("Moving {} steps back.", (Object)Math.abs(difference));
            for (int i = 0; i > difference; --i) {
                this.back();
            }
        } else {
            logger.debug("Moving {} steps forward.", (Object)difference);
            for (int i = 0; i < difference; ++i) {
                this.next();
            }
        }
        this.currentLocation = newLocation;
        return this;
    }

    private void checkIfCurrentLocationIsExpected(Location expectedLocation) {
        if (this.currentLocation != expectedLocation) {
            throw new IllegalStateException("Expected '" + expectedLocation.getName() + "', got '" + this.currentLocation.getName() + "' location.");
        }
    }

    public static enum Location {
        TEMPLATE_SELECTION(0, 0, "template selection"),
        DATASOURCE_ATTRIBUTES(1, 1, "datasource attributes"),
        JDBC_DRIVER(2, 2, "JDBC driver"),
        CONNECTION_SETTINGS(3, 4, "connection settings"),
        XA_PROPERTIES(-1, 3, "XA properties"),
        TEST_CONNECTION(4, 5, "test connection"),
        SUMMARY(5, 6, "summary");

        private int index;
        private int xaIndex;
        private String name;

        private Location(int index, int xaIndex, String name) {
            this.index = index;
            this.xaIndex = xaIndex;
            this.name = name;
        }

        public int getIndex(DatasourceType type) {
            int exportedIndex = type == DatasourceType.NON_XA ? this.index : this.xaIndex;
            if (exportedIndex < 0) {
                throw new IllegalStateException("Invalid index - maybe wrong datasource type?");
            }
            return exportedIndex;
        }

        public String getName() {
            return this.name;
        }
    }

    public static enum DatasourceType {
        NON_XA,
        XA;

    }
}

