/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.fragment.shared.table;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.BaseFragment;
import org.jboss.hal.testsuite.fragment.shared.table.TooFewColumnsException;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

public class ResourceTableRowFragment
extends BaseFragment {
    public static final String ROW_SELECTED_CLASS = "cellTableSelectedRow";

    public String getCellValue(int index) {
        WebElement cell = this.getCell(index);
        return cell.getText();
    }

    public void click() {
        this.getCell(0).click();
    }

    public WebElement getCell(int index) {
        By selector = By.className((String)"cellTableCell");
        List cells = this.root.findElements(selector);
        try {
            return (WebElement)cells.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new TooFewColumnsException("Cell with index " + index + " was not found on this row. There is probably too few columns (" + cells.size() + ").", e);
        }
    }

    public void view() {
        WebElement link = null;
        try {
            ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("resourcepager.viewlink.class")));
            link = this.root.findElement((By)selector);
        }
        catch (NoSuchElementException e) {
            String label = PropUtils.get("resourcepager.view.label");
            String cssClass = PropUtils.get("resourcepager.textlink.class");
            ByJQuery selector = ByJQuery.selector((String)("." + cssClass + ":contains('" + label + "')"));
            link = this.root.findElement((By)selector);
        }
        link.click();
        Graphene.waitGui().withTimeout(1500L, TimeUnit.MILLISECONDS);
    }

    public boolean isSelected() {
        return this.getRoot().getAttribute("class").contains(ROW_SELECTED_CLASS);
    }
}

