/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.config.datasource.DatasourceConfigArea;
import org.jboss.hal.testsuite.fragment.config.datasource.DatasourceWizard;
import org.jboss.hal.testsuite.fragment.config.datasource.PoolConfig;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.DomainConfigurationPage;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;

public class DatasourcesPage
extends ConfigurationPage
implements Navigatable {
    @Override
    public DatasourceConfigArea getConfig() {
        return this.getConfig(DatasourceConfigArea.class);
    }

    @Deprecated
    public void switchToXA() {
        this.selectMenu("XA");
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public DatasourceWizard getDatasourceWizard() {
        return Console.withBrowser(this.browser).openedWizard(DatasourceWizard.class);
    }

    public PoolConfig getPoolConfig() {
        return this.getConfig().switchTo("Pool", PoolConfig.class);
    }

    private FinderNavigation createNavigationToDatasourcesColumn() {
        return this.createNavigationToDatasourcesColumn(ConfigUtils.getDefaultProfile());
    }

    private FinderNavigation createNavigationToDatasourcesColumn(String profileName) {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainConfigurationPage.class).step("Configuration", "Profiles").step("Profile", profileName) : new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems");
        return navigation.step("Subsystem", "Datasources");
    }

    private void invokeActionOnDatasourceRow(Action action, DatasourceType type, String name) {
        Row row = this.createNavigationToDatasourcesColumn().step("Type", type.getTypeColumnLabel()).step(type.getFinalColumnLabel(), name).selectRow(true);
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke(action.getActionLabel());
    }

    private void invokeActionOnDatasourceColumn(Action action, DatasourceType type) {
        this.invokeActionOnDatasourceColumn(action, type, ConfigUtils.getDefaultProfile());
    }

    private void invokeActionOnDatasourceColumn(Action action, DatasourceType type, String profileName) {
        Column column = this.createNavigationToDatasourcesColumn(profileName).step("Type", type.getTypeColumnLabel()).step(type.getFinalColumnLabel()).selectColumn(true);
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        column.invoke(action.getActionLabel());
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    @Override
    public void navigate() {
        this.createNavigationToDatasourcesColumn().selectColumn();
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    public void invokeAddDatasource() {
        this.invokeActionOnDatasourceColumn(Action.ADD, DatasourceType.NON_XA);
    }

    public void invokeAddDatasourceOnProfile(String profileName) {
        this.invokeActionOnDatasourceColumn(Action.ADD, DatasourceType.NON_XA, profileName);
    }

    public void invokeAddXADatasource() {
        this.invokeActionOnDatasourceColumn(Action.ADD, DatasourceType.XA);
    }

    public void invokeViewDatasource(String name) {
        this.invokeActionOnDatasourceRow(Action.VIEW, DatasourceType.NON_XA, name);
        Application.waitUntilVisible();
    }

    public void invokeViewXADatasource(String name) {
        this.invokeActionOnDatasourceRow(Action.VIEW, DatasourceType.XA, name);
        Application.waitUntilVisible();
    }

    private static enum Action {
        VIEW("View"),
        ADD("Add");

        private String actionLabel;

        private Action(String actionLabel) {
            this.actionLabel = actionLabel;
        }

        public String getActionLabel() {
            return this.actionLabel;
        }
    }

    private static enum DatasourceType {
        XA("XA", "XA Datasource"),
        NON_XA("Non-XA", "Datasource");

        private String typeColumnLabel;
        private String finalColumnLabel;

        private DatasourceType(String typeColumnLabel, String finalColumnLabel) {
            this.typeColumnLabel = typeColumnLabel;
            this.finalColumnLabel = finalColumnLabel;
        }

        public String getTypeColumnLabel() {
            return this.typeColumnLabel;
        }

        public String getFinalColumnLabel() {
            return this.finalColumnLabel;
        }
    }
}

