/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.drone.api.annotation.Drone;
import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.wait.IsElementBuilder;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.jca.JCAConfigArea;
import org.jboss.hal.testsuite.fragment.formeditor.Editor;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class JCAPage
extends ConfigurationPage
implements Navigatable {
    @Drone
    private WebDriver browser;

    @Override
    public JCAConfigArea getConfig() {
        return this.getConfig(JCAConfigArea.class);
    }

    public void switchToConnectionDefinitions() {
        WebElement viewPanel = this.browser.findElement(By.className((String)"paged-view-navigation-container"));
        WebElement editLink = viewPanel.findElement(By.linkText((String)"Connection Definitions"));
        editLink.click();
    }

    public void switchToArchiveValidation() {
        WebElement archive = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Archive Validation)"));
        archive.click();
    }

    public void switchToSizing() {
        WebElement archive = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Sizing)"));
        archive.click();
    }

    public void switchToBeanValidation() {
        WebElement bean = this.browser.findElement((By)ByJQuery.selector((String)"div.gwt-Label:contains(Bean Validation)"));
        bean.click();
    }

    public void switchToBootstrapContextsTab() {
        this.switchTab("Bootstrap Contexts");
    }

    public void switchToWorkManagerTab() {
        this.switchTab("Work Manager");
    }

    public void clickView() {
        WebElement view = this.browser.findElement(By.className((String)"viewlink-cell"));
        view.click();
    }

    public Editor edit() {
        WebElement button = this.getEditButton();
        button.click();
        ((IsElementBuilder)Graphene.waitGui().until().element(button).is().not()).visible();
        return this.getConfig().getEditor();
    }

    private WebElement getEditButton() {
        ByJQuery selector = ByJQuery.selector((String)("." + PropUtils.get("configarea.edit.button.class") + ":visible"));
        return this.getContentRoot().findElement((By)selector);
    }

    public ConfigFragment getWindowFragment() {
        WebElement editPanel = this.browser.findElement(By.className((String)"default-window-content"));
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)editPanel);
    }

    @Override
    public void navigate() {
        FinderNavigation navigation = new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems").step("Subsystem", "JCA");
        navigation.selectRow().invoke("View");
        Application.waitUntilVisible();
    }
}

