/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.fragment.ConfigFragment;
import org.jboss.hal.testsuite.fragment.config.jgroups.ExecutorTabFragment;
import org.jboss.hal.testsuite.fragment.config.jgroups.JGroupsConfigArea;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

@Location(value="#jgroups")
public class JGroupsPage
extends ConfigurationPage {
    public void selectStackByName(String name) {
        ((ResourceTableRowFragment)this.getResourceManager().getResourceTable().getRowByText(0, name)).view();
    }

    public void openExecutors() {
        ByJQuery parent = ByJQuery.selector((String)"table.gwt-DisclosurePanel.default-disclosure");
        WebElement root = this.getContentRoot().findElement((By)parent);
        ExecutorTabFragment executorTabFragment = (ExecutorTabFragment)Graphene.createPageFragment(ExecutorTabFragment.class, (WebElement)root);
        executorTabFragment.openExecutors();
    }

    public void switchToTransport() {
        this.switchTo("Transport");
    }

    public void switchToProtocols() {
        this.switchTo("Protocols");
    }

    public void switchToProtocol(String protocol) {
        this.switchToProtocols();
        ((ResourceTableRowFragment)this.getResourceManager().getResourceTable().getRowByText(0, protocol)).click();
    }

    public void switchTo(String name) {
        this.switchView(name);
        Console.withBrowser(this.browser).waitUntilLoaded();
    }

    @Override
    public JGroupsConfigArea getConfig() {
        return this.getConfig(JGroupsConfigArea.class);
    }

    public void editTextAndSave(String identifier, String value) {
        this.getConfigFragment().editTextAndSave(identifier, value);
    }

    @Override
    public ConfigFragment getConfigFragment() {
        JGroupsConfigArea area = this.getConfig();
        return (ConfigFragment)Graphene.createPageFragment(ConfigFragment.class, (WebElement)area.getRoot());
    }
}

