/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.config;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.arquillian.graphene.page.Location;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.Column;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.finder.Row;
import org.jboss.hal.testsuite.fragment.ConfigAreaFragment;
import org.jboss.hal.testsuite.fragment.config.mail.MailServerFragment;
import org.jboss.hal.testsuite.fragment.config.mail.MailSessionWizard;
import org.jboss.hal.testsuite.fragment.config.mail.MailSessionsFragment;
import org.jboss.hal.testsuite.page.config.ConfigurationPage;
import org.jboss.hal.testsuite.page.config.StandaloneConfigEntryPoint;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Location(value="#profile")
public class MailSessionsPage
extends ConfigurationPage {
    private static final Logger log = LoggerFactory.getLogger(MailSessionsPage.class);
    private static final String MAIL_SESSION_LABEL = "Mail Session";
    private static final String ATTRIBUTES = "Attributes";
    private static final By BACK_ANCHOR = ByJQuery.selector((String)"a:contains('Back')");
    private static final By CONTENT = ByJQuery.selector((String)("." + PropUtils.get("page.content.gwt-layoutpanel") + ":visible"));
    private static final By SESSIONCONTENT = ByJQuery.selector((String)("." + PropUtils.get("page.content.rhs.class") + ":visible"));

    @Override
    public void navigate() {
        this.getFinderNavigation().selectColumn();
        Application.waitUntilVisible();
    }

    private FinderNavigation getFinderNavigation() {
        return new FinderNavigation(this.browser, StandaloneConfigEntryPoint.class).step("Configuration", "Subsystems").step("Subsystem", "Mail");
    }

    public MailSessionsFragment getMailSessions() {
        this.backIfAvailable();
        WebElement root = this.getContentRoot().findElement(CONTENT);
        return (MailSessionsFragment)Graphene.createPageFragment(MailSessionsFragment.class, (WebElement)root);
    }

    public MailServerFragment getMailServers(String jndiName) {
        this.backIfAvailable();
        this.getResourceManager().viewByName(jndiName);
        WebElement fragmentRoot = this.getContentRoot().findElement(CONTENT);
        return (MailServerFragment)Graphene.createPageFragment(MailServerFragment.class, (WebElement)fragmentRoot);
    }

    public MailServerFragment getSesionsServers() {
        WebElement fragmentRoot = this.getContentRoot().findElement(SESSIONCONTENT);
        return (MailServerFragment)Graphene.createPageFragment(MailServerFragment.class, (WebElement)fragmentRoot);
    }

    public void viewMailSession(String sessionName) {
        this.invokeOperationOnMailSession("View", sessionName);
        Application.waitUntilVisible();
    }

    public void removeMailSession(String sessionName) {
        this.invokeOperationOnMailSession("Remove", sessionName);
    }

    public void viewMailSessionAtributesPopUp(String sessionName) {
        this.invokeOperationOnMailSession(ATTRIBUTES, sessionName);
    }

    public boolean addMailSession(String sessionName, String mailName) {
        this.invokeOperationOnMailSessionColumn("Add");
        MailSessionWizard wizard = Console.withBrowser(this.browser).openedWizard(MailSessionWizard.class);
        return wizard.jndiName(sessionName).name(mailName).finish();
    }

    private void invokeOperationOnMailSession(String operationName, String sessionName) {
        Row row = this.getFinderNavigation().step(MAIL_SESSION_LABEL, sessionName).selectRow();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        row.invoke(operationName);
    }

    private void invokeOperationOnMailSessionColumn(String action) {
        Column column = this.getFinderNavigation().step(MAIL_SESSION_LABEL).selectColumn();
        Console.withBrowser(this.browser).dismissReloadRequiredWindowIfPresent();
        column.invoke(action);
    }

    @Override
    public ConfigAreaFragment getConfig() {
        ByJQuery selector = ByJQuery.selector((String)"table.default-tabpanel.master_detail-detail");
        WebElement root = this.browser.findElement((By)selector);
        return (ConfigAreaFragment)Graphene.createPageFragment(ConfigAreaFragment.class, (WebElement)root);
    }

    public void switchToCredentialReferenceTab() {
        this.getConfig().clickTabByLabel("Credential Reference");
    }

    private void backIfAvailable() {
        try {
            WebElement back = this.getContentRoot().findElement(BACK_ANCHOR);
            if (back.isDisplayed()) {
                back.click();
            }
        }
        catch (NoSuchElementException e) {
            log.debug("No back anchor found");
        }
    }
}

