/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.fragment.shared.table.ResourceTableRowFragment;
import org.jboss.hal.testsuite.page.MetricsPage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.util.Console;
import org.jboss.hal.testsuite.util.PropUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class BatchRuntimePage
extends MetricsPage
implements Navigatable {
    @Override
    public void navigate() {
        this.navigate2runtimeSubsystem("Batch");
    }

    public BatchRuntimePage navigate2jobs() {
        this.navigate();
        this.switchTab("Jobs");
        Console.withBrowser(this.browser).waitUntilLoaded();
        return this;
    }

    public List<ResourceTableRowFragment> getAllRows() {
        return this.getResourceManager().getResourceTable().getAllRows();
    }

    public Set<ResourceTableRowFragment> getRowsForJob(String jobFileName) {
        return this.getAllRows().stream().filter(row -> row.getCell(1).getText().equals(jobFileName)).collect(Collectors.toSet());
    }

    public ResourceTableRowFragment selectRowForJob(String jobFileName) {
        return this.getResourceManager().getResourceTable().selectRowByText(1, jobFileName);
    }

    public ResourceTableRowFragment getRowByExecutionId(String executionId) {
        return this.getResourceManager().getResourceTable().getRowByText(2, executionId);
    }

    public String getDeploymentFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(0);
    }

    public String getJobFileNameFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(1);
    }

    public String getExecutionIdFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(2);
    }

    public String getInstanceIdFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(3);
    }

    public String getBatchStatusFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(4);
    }

    public String getStartTimeFromRow(ResourceTableRowFragment jobTableRow) {
        return jobTableRow.getCellValue(5);
    }

    public void setFilterText(String text) {
        WebElement filterElement = Console.withBrowser(this.browser).findElement((By)ByJQuery.selector((String)"input[type='text']"), this.getContentPanel());
        filterElement.clear();
        filterElement.sendKeys(new CharSequence[]{text});
    }

    private WebElement getContentPanel() {
        ByJQuery contentPanelSelector = ByJQuery.selector((String)("." + PropUtils.get("page.content.rhs.class") + ":visible"));
        return this.getContentRoot().findElement((By)contentPanelSelector);
    }
}

