/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.page.runtime;

import org.jboss.arquillian.graphene.Graphene;
import org.jboss.arquillian.graphene.findby.ByJQuery;
import org.jboss.hal.testsuite.finder.Application;
import org.jboss.hal.testsuite.finder.FinderNavigation;
import org.jboss.hal.testsuite.fragment.runtime.configurationchanges.EnableConfigurationChangesDialog;
import org.jboss.hal.testsuite.fragment.runtime.configurationchanges.table.ConfigurationChangesTableFragment;
import org.jboss.hal.testsuite.page.BasePage;
import org.jboss.hal.testsuite.page.Navigatable;
import org.jboss.hal.testsuite.page.runtime.DomainRuntimeEntryPoint;
import org.jboss.hal.testsuite.page.runtime.StandaloneRuntimeEntryPoint;
import org.jboss.hal.testsuite.util.ConfigUtils;
import org.jboss.hal.testsuite.util.Console;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.WebElement;

public class ConfigurationChangesPage
extends BasePage
implements Navigatable {
    @Override
    public void navigate() {
        FinderNavigation navigation = ConfigUtils.isDomain() ? new FinderNavigation(this.browser, DomainRuntimeEntryPoint.class).step("Browse Domain By", "Hosts").step("Host", ConfigUtils.getDefaultHost()) : new FinderNavigation(this.browser, StandaloneRuntimeEntryPoint.class).step("Server", "Standalone Server");
        navigation.selectRow().invoke("Configuration Changes");
        Application.waitUntilVisible();
    }

    public EnableConfigurationChangesDialog openEnableConfigurationChangesDialog() {
        this.clickButton("Enable");
        return Console.withBrowser(this.browser).openedWindow(EnableConfigurationChangesDialog.class);
    }

    public ConfigurationChangesTableFragment getConfigurationChangesTable() {
        By rootSelector = ConfigurationChangesTableFragment.SELECTOR;
        WebElement root = this.getContentRoot().findElement(rootSelector);
        return (ConfigurationChangesTableFragment)Graphene.createPageFragment(ConfigurationChangesTableFragment.class, (WebElement)root);
    }

    public void disable() {
        this.clickButton("Disable");
    }

    public void refresh() {
        this.clickButton("Refresh");
    }

    public Filter filter() {
        return new Filter(this);
    }

    public static final class Filter {
        private WebElement filterInput;
        private ConfigurationChangesPage page;

        private Filter(ConfigurationChangesPage page) {
            this.page = page;
            this.filterInput = page.getContentRoot().findElement((By)ByJQuery.selector((String)".gwt-TextBox"));
        }

        private ConfigurationChangesTableFragment.State changeState(CharSequence charSequence) {
            this.filterInput.click();
            this.filterInput.sendKeys(new CharSequence[]{charSequence});
            return this.page.getConfigurationChangesTable().getState();
        }

        public ConfigurationChangesTableFragment.State appendSymbol(char symbol) {
            return this.changeState(String.valueOf(symbol));
        }

        public ConfigurationChangesTableFragment.State removeSymbol() {
            return this.changeState((CharSequence)Keys.BACK_SPACE);
        }

        public ConfigurationChangesTableFragment.State setFilter(String filter) {
            return this.changeState(filter);
        }

        public ConfigurationChangesTableFragment.State clearFilter() {
            return this.changeState(Keys.chord((CharSequence[])new CharSequence[]{Keys.CONTROL, "a"}) + Keys.DELETE);
        }

        public String getCurrentFilter() {
            return this.filterInput.getAttribute("value");
        }
    }
}

