/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.testlistener;

import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.RunListener;

public abstract class TestCaseRunListener
extends RunListener {
    private String currentTestCaseCanonicalName;
    private boolean testCaseJustStarted;

    public void testRunStarted(Description description) throws Exception {
        this.testCaseJustStarted = true;
        this.beforeTestCase();
    }

    public void testIgnored(Description description) throws Exception {
        this.recordTestCaseNameIfRunFirstInTestCase(description);
    }

    public void testStarted(Description description) throws Exception {
        this.recordTestCaseNameIfRunFirstInTestCase(description);
    }

    public void testRunFinished(Result result) throws Exception {
        this.afterTestCase();
    }

    protected String getCurrentTestCaseCanonicalName() {
        return this.currentTestCaseCanonicalName;
    }

    protected void beforeTestCase() throws Exception {
    }

    protected void afterTestCase() throws Exception {
    }

    private void recordTestCaseNameIfRunFirstInTestCase(Description description) {
        if (this.testCaseJustStarted) {
            this.currentTestCaseCanonicalName = description.getTestClass().getCanonicalName();
            this.testCaseJustStarted = false;
        }
    }
}

