/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util;

import java.util.Properties;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public abstract class EJBUtils {
    protected static final Logger log = Logger.getLogger(EJBUtils.class.getName());

    public static <T> T lookup(Class<T> remoteClass, Class<?> beanClass, String archiveName, boolean stateful) throws NamingException {
        return EJBUtils.lookup(remoteClass, beanClass, "", archiveName, stateful);
    }

    public static <T> T lookup(Class<T> remoteClass, Class<?> beanClass, String appName, String archiveName, boolean stateful) throws NamingException {
        String myContext = EJBUtils.createRemoteEjbJndiContext(appName, archiveName, "", beanClass.getSimpleName(), remoteClass.getName(), stateful);
        Context ctx = EJBUtils.createNamingContext();
        return remoteClass.cast(ctx.lookup(myContext));
    }

    public static String createRemoteEjbJndiContext(String appName, String moduleName, String distinctName, String beanName, String viewClassName, boolean isStateful) {
        return "ejb:" + appName + "/" + moduleName + "/" + distinctName + "/" + beanName + "!" + viewClassName + (isStateful ? "?stateful" : "");
    }

    public static Context createNamingContext() throws NamingException {
        Properties jndiProps = new Properties();
        jndiProps.setProperty("java.naming.factory.url.pkgs", "org.jboss.ejb.client.naming");
        return new InitialContext(jndiProps);
    }
}

