/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.testsuite.util.configurationchanges;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.hal.testsuite.util.configurationchanges.ConfigurationChange;
import org.jboss.hal.testsuite.util.configurationchanges.ConfigurationChangeBuilder;
import org.jboss.hal.testsuite.util.configurationchanges.ConfigurationChangesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wildfly.extras.creaper.core.online.ModelNodeResult;
import org.wildfly.extras.creaper.core.online.OnlineManagementClient;
import org.wildfly.extras.creaper.core.online.operations.Address;
import org.wildfly.extras.creaper.core.online.operations.Operations;

public class ConfigurationChangesResource
implements ConfigurationChangesProvider {
    private final Operations operations;
    private final Address serviceAddress;
    private static final String OPERATIONS = "operations";
    private static final String OP = "operation";
    private static final String COMPOSITE = "composite";
    private static final String STEPS = "steps";
    private static final String OP_ADDR = "address";
    private final Logger logger = LoggerFactory.getLogger(ConfigurationChangesResource.class);

    public ConfigurationChangesResource(OnlineManagementClient client) {
        this.operations = new Operations(client);
        this.serviceAddress = client.options().isDomain ? Address.host((String)client.options().defaultHost).and("subsystem", "core-management").and("service", "configuration-changes") : Address.subsystem((String)"core-management").and("service", "configuration-changes");
    }

    private Date parseDate(String datetimeString) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.parse(datetimeString);
    }

    private List<ConfigurationChange> getConfigurationChanges(Predicate<ConfigurationChange> predicate) throws IOException, ParseException {
        ModelNodeResult result = this.operations.invoke("list-changes", this.serviceAddress);
        result.assertSuccess();
        LinkedList<ConfigurationChange> changes = new LinkedList<ConfigurationChange>();
        for (ModelNode change : result.value().asList()) {
            this.logger.info(change.get(OPERATIONS).asString());
            ConfigurationChange configurationChange = new ConfigurationChangeBuilder().setDatetime(this.parseDate(change.get("operation-date").asString())).setAccessMechanism(change.get("access-mechanism").asString()).setRemoteAddress(this.formRemoteAddress(change.get("remote-address").asString())).setResult(change.get("outcome").asString()).setOperation(this.extractOperationName(change)).setResourceAddress(StringUtils.abbreviate((String)this.extractResourceAddress(change), (int)66)).build();
            if (!predicate.test(configurationChange)) continue;
            changes.add(configurationChange);
        }
        return changes;
    }

    private String formRemoteAddress(String originalRemoteAddress) {
        String[] clientAddressArr;
        if (originalRemoteAddress.contains("/") && (originalRemoteAddress = (clientAddressArr = originalRemoteAddress.split("/"))[0]).length() == 0) {
            originalRemoteAddress = clientAddressArr[1];
        }
        return originalRemoteAddress;
    }

    private String extractOperationName(ModelNode changeItem) {
        String opName = "";
        ModelNode operations = changeItem.get(OPERATIONS);
        for (ModelNode op1 : operations.asList()) {
            opName = op1.get(OP).asString();
        }
        return opName;
    }

    private String extractResourceAddress(ModelNode changeItem) {
        StringBuilder address = new StringBuilder();
        ModelNode operations = changeItem.get(OPERATIONS);
        for (ModelNode op1 : operations.asList()) {
            String opName = op1.get(OP).asString();
            if (COMPOSITE.equals(opName)) {
                List steps = op1.get(STEPS).asList();
                for (int idxStep = 0; idxStep < steps.size(); ++idxStep) {
                    ModelNode step = (ModelNode)steps.get(idxStep);
                    if (step.hasDefined(OP_ADDR)) {
                        ModelNode addressNode = step.get(OP_ADDR);
                        List modelNodes = addressNode.asList();
                        for (int i = 0; i < modelNodes.size(); ++i) {
                            ModelNode addr = (ModelNode)modelNodes.get(i);
                            Property p = addr.asProperty();
                            address.append(p.getName()).append(" = ").append(p.getValue().asString());
                            if (i + 1 >= modelNodes.size()) continue;
                            address.append(" / ");
                        }
                    }
                    if (idxStep + 1 >= steps.size()) continue;
                    address.append(" | ");
                }
                continue;
            }
            if (!op1.hasDefined(OP_ADDR)) continue;
            ModelNode addressNode = op1.get(OP_ADDR);
            List modelNodes = addressNode.asList();
            for (int i = 0; i < modelNodes.size(); ++i) {
                ModelNode addr = (ModelNode)modelNodes.get(i);
                Property p = addr.asProperty();
                address.append(p.getName()).append(" = ").append(p.getValue().asString());
                if (i + 1 >= modelNodes.size()) continue;
                address.append(" / ");
            }
        }
        return address.toString();
    }

    @Override
    public List<ConfigurationChange> getAllConfigurationChanges() throws IOException, ParseException {
        return this.getConfigurationChanges(change -> true);
    }

    public List<ConfigurationChange> getFilteredConfigurationChanges(String filter) throws ParseException, IOException {
        return this.getConfigurationChanges(configurationChange -> {
            try {
                return configurationChange.getAccessMechanism().contains(filter) || configurationChange.getDatetime().toString().contains(filter) || configurationChange.getRemoteAddress().contains(filter) || configurationChange.getResult().contains(filter) || configurationChange.getOperation().contains(filter) || configurationChange.getResourceAddress().contains(filter);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        });
    }
}

