/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.service.SecurityActions;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.ejb.client.remoting.IoFutureHelper;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.remoting3.Connection;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.Remoting;
import org.jboss.remoting3.remote.RemoteConnectionProviderFactory;
import org.jboss.remoting3.spi.ConnectionProviderFactory;
import org.xnio.IoFuture;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;

public class ApplicationClientStartService
implements Service<ApplicationClientStartService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"appClientStart"});
    private final InjectedValue<ApplicationClientDeploymentService> applicationClientDeploymentServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Component> applicationClientComponent = new InjectedValue();
    private final InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue;
    private final Method mainMethod;
    private final String[] parameters;
    private final ClassLoader classLoader;
    final String hostUrl;
    private Thread thread;
    private ComponentInstance instance;

    public ApplicationClientStartService(Method mainMethod, String[] parameters, String hostUrl, InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue, ClassLoader classLoader) {
        this.mainMethod = mainMethod;
        this.parameters = parameters;
        this.namespaceContextSelectorInjectedValue = namespaceContextSelectorInjectedValue;
        this.classLoader = classLoader;
        this.hostUrl = hostUrl;
    }

    public synchronized void start(StartContext context) throws StartException {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Endpoint endpoint = Remoting.createEndpoint((String)"endpoint", (OptionMap)OptionMap.EMPTY);
                    endpoint.addConnectionProvider("remote", (ConnectionProviderFactory)new RemoteConnectionProviderFactory(), OptionMap.create((Option)Options.SSL_ENABLED, (Object)Boolean.FALSE));
                    IoFuture futureConnection = endpoint.connect(new URI(ApplicationClientStartService.this.hostUrl), OptionMap.create((Option)Options.SASL_POLICY_NOANONYMOUS, (Object)Boolean.FALSE), (CallbackHandler)new AnonymousCallbackHandler());
                    Connection connection = (Connection)IoFutureHelper.get((IoFuture)futureConnection, (long)5L, (TimeUnit)TimeUnit.SECONDS);
                    try {
                        try {
                            ClassLoader oldTccl = SecurityActions.getContextClassLoader();
                            try {
                                try {
                                    SecurityActions.setContextClassLoader(ApplicationClientStartService.this.classLoader);
                                    EJBClientContext ejbClientContext = EJBClientContext.create();
                                    ejbClientContext.registerConnection(connection);
                                    ContextSelector previousSelector = EJBClientContext.setConstantContext((EJBClientContext)ejbClientContext);
                                    ((ApplicationClientDeploymentService)ApplicationClientStartService.this.applicationClientDeploymentServiceInjectedValue.getValue()).getDeploymentCompleteLatch().await();
                                    try {
                                        NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)ApplicationClientStartService.this.namespaceContextSelectorInjectedValue);
                                        ApplicationClientStartService.this.instance = ((Component)ApplicationClientStartService.this.applicationClientComponent.getValue()).createInstance();
                                        ApplicationClientStartService.this.mainMethod.invoke(null, new Object[]{ApplicationClientStartService.this.parameters});
                                    }
                                    finally {
                                        if (previousSelector != null) {
                                            EJBClientContext.setSelector((ContextSelector)previousSelector);
                                        }
                                        NamespaceContextSelector.popCurrentSelector();
                                    }
                                }
                                catch (Exception e) {
                                    AppClientLogger.ROOT_LOGGER.exceptionRunningAppClient(e, e.getClass().getSimpleName());
                                }
                                finally {
                                    SecurityActions.setContextClassLoader(oldTccl);
                                }
                            }
                            finally {
                                CurrentServiceContainer.getServiceContainer().shutdown();
                            }
                        }
                        finally {
                            connection.close();
                        }
                    }
                    finally {
                        endpoint.close();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        this.thread.start();
    }

    public synchronized void stop(StopContext context) {
        if (this.instance != null) {
            this.instance.destroy();
        }
        this.thread.interrupt();
        this.thread = null;
    }

    public ApplicationClientStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ApplicationClientDeploymentService> getApplicationClientDeploymentServiceInjectedValue() {
        return this.applicationClientDeploymentServiceInjectedValue;
    }

    public InjectedValue<Component> getApplicationClientComponent() {
        return this.applicationClientComponent;
    }

    public class AnonymousCallbackHandler
    implements CallbackHandler {
        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback current : callbacks) {
                if (!(current instanceof NameCallback)) {
                    throw new UnsupportedCallbackException(current);
                }
                NameCallback ncb = (NameCallback)current;
                ncb.setName("anonymous");
            }
        }
    }
}

