/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.service;

import java.lang.reflect.Method;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.appclient.logging.AppClientLogger;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.service.LazyConnectionContextSelector;
import org.jboss.as.appclient.service.SecurityActions;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentInstance;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.as.server.CurrentServiceContainer;
import org.jboss.ejb.client.ContextSelector;
import org.jboss.ejb.client.EJBClientContext;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class ApplicationClientStartService
implements Service<ApplicationClientStartService> {
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"appClientStart"});
    private final InjectedValue<ApplicationClientDeploymentService> applicationClientDeploymentServiceInjectedValue = new InjectedValue();
    private final InjectedValue<Component> applicationClientComponent = new InjectedValue();
    private final InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue;
    private final Method mainMethod;
    private final String[] parameters;
    private final ClassLoader classLoader;
    private final LazyConnectionContextSelector lazyConnectionContextSelector;
    private final CallbackHandler callbackHandler;
    final String hostUrl;
    private Thread thread;
    private ComponentInstance instance;

    public ApplicationClientStartService(Method mainMethod, String[] parameters, String hostUrl, InjectedEENamespaceContextSelector namespaceContextSelectorInjectedValue, ClassLoader classLoader, CallbackHandler callbackHandler) {
        this.mainMethod = mainMethod;
        this.parameters = parameters;
        this.namespaceContextSelectorInjectedValue = namespaceContextSelectorInjectedValue;
        this.classLoader = classLoader;
        this.hostUrl = hostUrl;
        this.callbackHandler = callbackHandler;
        this.lazyConnectionContextSelector = new LazyConnectionContextSelector(hostUrl, callbackHandler);
    }

    public synchronized void start(StartContext context) throws StartException {
        this.thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    ClassLoader oldTccl = SecurityActions.getContextClassLoader();
                    try {
                        try {
                            SecurityActions.setContextClassLoader(ApplicationClientStartService.this.classLoader);
                            EJBClientContext.setSelector((ContextSelector)ApplicationClientStartService.this.lazyConnectionContextSelector);
                            ((ApplicationClientDeploymentService)ApplicationClientStartService.this.applicationClientDeploymentServiceInjectedValue.getValue()).getDeploymentCompleteLatch().await();
                            NamespaceContextSelector.setDefault((NamespaceContextSelector)ApplicationClientStartService.this.namespaceContextSelectorInjectedValue);
                            ApplicationClientStartService.this.instance = ((Component)ApplicationClientStartService.this.applicationClientComponent.getValue()).createInstance();
                            ApplicationClientStartService.this.mainMethod.invoke(null, new Object[]{ApplicationClientStartService.this.parameters});
                        }
                        catch (Exception e) {
                            AppClientLogger.ROOT_LOGGER.exceptionRunningAppClient(e, e.getClass().getSimpleName());
                        }
                        finally {
                            SecurityActions.setContextClassLoader(oldTccl);
                        }
                    }
                    finally {
                        CurrentServiceContainer.getServiceContainer().shutdown();
                    }
                }
                finally {
                    ApplicationClientStartService.this.lazyConnectionContextSelector.close();
                }
            }
        });
        this.thread.start();
    }

    public synchronized void stop(StopContext context) {
        if (this.instance != null) {
            this.instance.destroy();
        }
        this.thread.interrupt();
        this.thread = null;
    }

    public ApplicationClientStartService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public InjectedValue<ApplicationClientDeploymentService> getApplicationClientDeploymentServiceInjectedValue() {
        return this.applicationClientDeploymentServiceInjectedValue;
    }

    public InjectedValue<Component> getApplicationClientComponent() {
        return this.applicationClientComponent;
    }
}

