/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.jboss.as.appclient.logging.AppClientMessages;
import org.jboss.as.appclient.subsystem.ApplicationClientConfigurationPersister;
import org.jboss.as.appclient.subsystem.CommandLineArgument;
import org.jboss.as.appclient.subsystem.SecurityActions;
import org.jboss.as.appclient.subsystem.parsing.AppClientXml;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.server.Bootstrap;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.SystemExiter;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.handlers.ConsoleHandler;
import org.jboss.logmanager.log4j.BridgeRepositorySelector;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.stdio.StdioContext;

public final class Main {
    public static void usage() {
        CommandLineArgument.printUsage(System.out);
    }

    private Main() {
    }

    public static void main(String[] args) {
        SecurityActions.setSystemProperty("log4j.defaultInitOverride", "true");
        new BridgeRepositorySelector().start();
        try {
            Class.forName(ConsoleHandler.class.getName(), true, ConsoleHandler.class.getClassLoader());
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        StdioContext.install();
        try {
            Module.registerURLStreamHandlerFactoryModule((Module)Module.getBootModuleLoader().loadModule(ModuleIdentifier.create((String)"org.jboss.vfs")));
            final ParsedOptions options = Main.determineEnvironment(args, new Properties(SecurityActions.getSystemProperties()), SecurityActions.getSystemEnvironment(), ServerEnvironment.LaunchType.APPCLIENT);
            ServerEnvironment serverEnvironment = options.environment;
            List<String> clientArgs = options.clientArguments;
            if (clientArgs.isEmpty()) {
                System.err.println(AppClientMessages.MESSAGES.appClientNotSpecified());
                Main.usage();
                Main.abort(null);
            } else {
                String deploymentName;
                String earPath;
                final QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                String file = clientArgs.get(0);
                final List<String> params = clientArgs.subList(1, clientArgs.size());
                int pos = file.lastIndexOf("#");
                if (pos == -1) {
                    earPath = file;
                    deploymentName = null;
                } else {
                    deploymentName = file.substring(pos + 1);
                    earPath = file.substring(0, pos);
                }
                File realFile = new File(earPath);
                if (!realFile.exists()) {
                    throw AppClientMessages.MESSAGES.cannotFindAppClient(realFile.getAbsoluteFile());
                }
                final AppClientXml parser = new AppClientXml(Module.getBootModuleLoader());
                Bootstrap bootstrap = Bootstrap.Factory.newInstance();
                Bootstrap.Configuration configuration = new Bootstrap.Configuration();
                configuration.setServerEnvironment(serverEnvironment);
                configuration.setModuleLoader(Module.getBootModuleLoader());
                Bootstrap.ConfigurationPersisterFactory configurationPersisterFactory = new Bootstrap.ConfigurationPersisterFactory(){

                    public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                        return new ApplicationClientConfigurationPersister(earPath, deploymentName, options.hostUrl, params, serverEnvironment.getServerConfigurationFile().getBootFile(), rootElement, (XMLElementReader<List<ModelNode>>)parser);
                    }
                };
                configuration.setConfigurationPersisterFactory(configurationPersisterFactory);
                bootstrap.bootstrap(configuration, Collections.emptyList()).get();
            }
        }
        catch (Throwable t) {
            Main.abort(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void abort(Throwable t) {
        try {
            if (t != null) {
                t.printStackTrace(System.err);
            }
        }
        finally {
            SystemExiter.exit((int)1);
        }
    }

    public static ParsedOptions determineEnvironment(String[] args, Properties systemProperties, Map<String, String> systemEnvironment, ServerEnvironment.LaunchType launchType) {
        ArrayList<String> clientArguments = new ArrayList<String>();
        ParsedOptions ret = new ParsedOptions();
        ret.clientArguments = clientArguments;
        int argsLength = args.length;
        String appClientConfig = "appclient.xml";
        boolean clientArgs = false;
        for (int i = 0; i < argsLength; ++i) {
            String arg = args[i];
            try {
                String urlSpec;
                if (clientArgs) {
                    clientArguments.add(arg);
                    continue;
                }
                if ("--version".equals(arg) || "-v".equals(arg) || "-version".equals(arg) || "-V".equals(arg)) {
                    System.out.println("JBoss Application Server " + org.jboss.as.process.Main.getVersionString());
                    return null;
                }
                if ("--help".equals(arg) || "-h".equals(arg) || "-help".equals(arg)) {
                    Main.usage();
                    return null;
                }
                if ("--properties".equals(arg) || "-properties".equals(arg) || "-P".equals(arg)) {
                    if (Main.processProperties(arg, args[++i])) continue;
                    return null;
                }
                if (arg.startsWith("--properties")) {
                    urlSpec = Main.parseValue(arg, "--properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-P")) {
                    urlSpec = Main.parseValue(arg, "-P");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.startsWith("-properties")) {
                    urlSpec = Main.parseValue(arg, "-properties");
                    if (urlSpec != null && Main.processProperties(arg, urlSpec)) continue;
                    return null;
                }
                if (arg.equals("-H") || arg.equals("--host")) {
                    ret.hostUrl = urlSpec = args[++i];
                    continue;
                }
                if (arg.startsWith("-H")) {
                    ret.hostUrl = urlSpec = Main.parseValue(arg, "-H");
                    continue;
                }
                if (arg.startsWith("--host")) {
                    ret.hostUrl = urlSpec = Main.parseValue(arg, "--host");
                    continue;
                }
                if (arg.startsWith("-D")) {
                    String value;
                    String name;
                    int idx = arg.indexOf("=");
                    if (idx == -1) {
                        name = arg.substring(2);
                        value = "true";
                    } else {
                        name = arg.substring(2, idx);
                        value = arg.substring(idx + 1, arg.length());
                    }
                    systemProperties.setProperty(name, value);
                    SecurityActions.setSystemProperty(name, value);
                    continue;
                }
                if (arg.startsWith("--appclient-config")) {
                    appClientConfig = Main.parseValue(arg, "--appclient-config");
                    continue;
                }
                if (arg.startsWith("-")) {
                    System.out.println(AppClientMessages.MESSAGES.unknownOption(arg));
                    Main.usage();
                    return null;
                }
                clientArgs = true;
                clientArguments.add(arg);
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                System.err.println(AppClientMessages.MESSAGES.argumentExpected(arg));
                Main.usage();
                return null;
            }
        }
        String hostControllerName = null;
        ret.environment = new ServerEnvironment(hostControllerName, systemProperties, systemEnvironment, appClientConfig, launchType, null);
        return ret;
    }

    private static String parseValue(String arg, String key) {
        String value = null;
        int splitPos = key.length();
        if (arg.length() <= splitPos + 1 || arg.charAt(splitPos) != '=') {
            Main.usage();
        } else {
            value = arg.substring(splitPos + 1);
        }
        return value;
    }

    private static boolean processProperties(String arg, String urlSpec) {
        URL url = null;
        try {
            url = Main.makeURL(urlSpec);
            Properties props = System.getProperties();
            props.load(url.openConnection().getInputStream());
            return true;
        }
        catch (MalformedURLException e) {
            System.err.println(AppClientMessages.MESSAGES.malformedUrl(arg));
            Main.usage();
            return false;
        }
        catch (IOException e) {
            System.err.println(AppClientMessages.MESSAGES.cannotLoadProperties(url));
            Main.usage();
            return false;
        }
    }

    private static URL makeURL(String urlspec) throws MalformedURLException {
        URL url;
        urlspec = urlspec.trim();
        try {
            url = new URL(urlspec);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getFile()).getCanonicalFile();
                url = file.toURI().toURL();
            }
        }
        catch (Exception e) {
            try {
                File file = new File(urlspec).getCanonicalFile();
                url = file.toURI().toURL();
            }
            catch (Exception n) {
                throw new MalformedURLException(n.toString());
            }
        }
        return url;
    }

    private static final class ParsedOptions {
        ServerEnvironment environment;
        List<String> clientArguments;
        String hostUrl = "remote://localhost:4447";

        private ParsedOptions() {
        }
    }
}

