/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.appclient.subsystem;

import java.io.File;
import java.util.List;
import org.jboss.as.appclient.deployment.ActiveApplicationClientProcessor;
import org.jboss.as.appclient.deployment.AppClientJBossAllParser;
import org.jboss.as.appclient.deployment.ApplicationClientDependencyProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientManifestProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientParsingDeploymentProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStartProcessor;
import org.jboss.as.appclient.deployment.ApplicationClientStructureProcessor;
import org.jboss.as.appclient.service.ApplicationClientDeploymentService;
import org.jboss.as.appclient.subsystem.AppClientSubsystemResourceDefinition;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelController;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXMLParser;
import org.jboss.as.server.deployment.jbossallxml.JBossAllXmlParserRegisteringProcessor;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;

class AppClientSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final AppClientSubsystemAdd INSTANCE = new AppClientSubsystemAdd();
    private final String[] EMPTY_STRING = new String[0];

    private AppClientSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition attr : AppClientSubsystemResourceDefinition.ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        final String deployment = AppClientSubsystemResourceDefinition.DEPLOYMENT.resolveModelAttribute(context, model).asString();
        File file = new File(AppClientSubsystemResourceDefinition.FILE.resolveModelAttribute(context, model).asString());
        final String hostUrl = model.hasDefined("host-url") ? AppClientSubsystemResourceDefinition.HOST_URL.resolveModelAttribute(context, model).asString() : null;
        final String connectionPropertiesUrl = model.hasDefined("connection-properties-url") ? AppClientSubsystemResourceDefinition.CONNECTION_PROPERTIES_URL.resolveModelAttribute(context, model).asString() : null;
        final List parameters = AppClientSubsystemResourceDefinition.PARAMETERS.unwrap(context, model);
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                if (deployment != null && !deployment.isEmpty()) {
                    processorTarget.addDeploymentProcessor("appclient", Phase.STRUCTURE, 3840, (DeploymentUnitProcessor)new ApplicationClientStructureProcessor(deployment));
                }
                processorTarget.addDeploymentProcessor("appclient", Phase.STRUCTURE, 2576, (DeploymentUnitProcessor)new JBossAllXmlParserRegisteringProcessor(AppClientJBossAllParser.ROOT_ELEMENT, AppClientJBossAllParser.ATTACHMENT_KEY, (JBossAllXMLParser)new AppClientJBossAllParser()));
                processorTarget.addDeploymentProcessor("appclient", Phase.PARSE, 4353, (DeploymentUnitProcessor)new ApplicationClientParsingDeploymentProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.POST_MODULE, 7936, (DeploymentUnitProcessor)new ApplicationClientManifestProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.POST_MODULE, 8192, (DeploymentUnitProcessor)new ActiveApplicationClientProcessor(deployment));
                processorTarget.addDeploymentProcessor("appclient", Phase.DEPENDENCIES, 8192, (DeploymentUnitProcessor)new ApplicationClientDependencyProcessor());
                processorTarget.addDeploymentProcessor("appclient", Phase.INSTALL, 8208, (DeploymentUnitProcessor)new ApplicationClientStartProcessor(hostUrl, connectionPropertiesUrl, parameters.toArray(AppClientSubsystemAdd.this.EMPTY_STRING)));
            }
        }, OperationContext.Stage.RUNTIME);
        ApplicationClientDeploymentService service = new ApplicationClientDeploymentService(file);
        newControllers.add(context.getServiceTarget().addService(ApplicationClientDeploymentService.SERVICE_NAME, (Service)service).addDependency(Services.JBOSS_SERVER_CONTROLLER, ModelController.class, service.getControllerValue()).install());
    }
}

