/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.util.Iterator;
import java.util.Set;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.domain.ArchiveDeployer;
import org.jboss.as.arquillian.container.domain.Domain;
import org.jboss.as.arquillian.container.domain.EmptyConfiguration;
import org.jboss.as.arquillian.container.domain.LazyHttpContext;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.util.NotImplementedException;

public class ServerGroupContainer
implements DeployableContainer<EmptyConfiguration> {
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    @Inject
    @ContainerScoped
    private InstanceProducer<ModelControllerClient> clientInst;
    @Inject
    private Instance<ContainerRegistry> containerRegistryInst;
    private ManagementClient client;
    private ArchiveDeployer deployer;
    private Domain.ServerGroup serverGroup;
    private Domain domain;
    private int operationTimeout;

    public ServerGroupContainer(ManagementClient client, ArchiveDeployer deployer, Domain domain, Domain.ServerGroup serverGroup, int operationTimeout) {
        this.client = client;
        this.deployer = deployer;
        this.domain = domain;
        this.serverGroup = serverGroup;
        this.operationTimeout = operationTimeout;
    }

    public Class<EmptyConfiguration> getConfigurationClass() {
        return EmptyConfiguration.class;
    }

    public void setup(EmptyConfiguration configuration) {
        this.archiveDeployerInst.set((Object)this.deployer);
        this.clientInst.set((Object)this.client.getControllerClient());
    }

    public void start() throws LifecycleException {
        this.client.startServerGroup(this.serverGroup.getName());
        this.waitForGroupMembers(true);
        this.updateGroupMembersContainerState(Container.State.STARTED);
    }

    public void stop() throws LifecycleException {
        this.client.stopServerGroup(this.serverGroup.getName());
        this.waitForGroupMembers(false);
        this.updateGroupMembersContainerState(Container.State.STOPPED);
    }

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("Servlet 3.0");
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        String uniqueName = this.deployer.deploy(archive, this.serverGroup.getName());
        ProtocolMetaData metaData = new ProtocolMetaData();
        for (Domain.Server server : this.domain.getServersInGroup(this.serverGroup)) {
            metaData.addContext((Object)new LazyHttpContext(server, uniqueName, this.client));
        }
        return metaData;
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        this.deployer.undeploy(archive.getName(), this.serverGroup.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    private void waitForGroupMembers(boolean shouldBeStarted) {
        long timeout;
        Set<Domain.Server> servers = this.domain.getServersInGroup(this.serverGroup);
        long sleep = 100L;
        for (timeout = (long)(this.operationTimeout * 1000); timeout > 0L && servers.size() > 0; timeout -= sleep) {
            Iterator<Domain.Server> serverIterator = servers.iterator();
            while (serverIterator.hasNext()) {
                Domain.Server server = serverIterator.next();
                if (shouldBeStarted != this.client.isServerStarted(server)) continue;
                serverIterator.remove();
            }
            try {
                Thread.sleep(sleep);
                continue;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Failed waiting for servers to " + (shouldBeStarted ? "start" : "stop"), e);
            }
        }
        if (timeout <= 0L) {
            throw new RuntimeException("Servers in group did not " + (shouldBeStarted ? "start" : "stop") + " within set timeout [serverGroupOperationTimeoutInSeconds=" + this.operationTimeout + "]. " + servers);
        }
    }

    private void updateGroupMembersContainerState(Container.State newState) {
        Set<Domain.Server> servers = this.domain.getServersInGroup(this.serverGroup);
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistryInst.get();
        for (Domain.Server server : servers) {
            registry.getContainer(server.getContainerName()).setState(newState);
        }
    }
}

