/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.spi.ApplicationArchiveProcessor;
import org.jboss.arquillian.spi.TestClass;
import org.jboss.as.arquillian.container.ManifestUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;

public class ModuleApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    static final List<String> defaultDependencies = new ArrayList<String>();
    static final List<String> jsfDependencies;

    public void process(Archive<?> appArchive, TestClass testClass) {
        if (!(appArchive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected " + appArchive);
        }
        final Manifest manifest = ManifestUtils.getOrCreateManifest(appArchive);
        Attributes attributes = manifest.getMainAttributes();
        String value = attributes.getValue("Dependencies");
        StringBuffer moduleDeps = new StringBuffer(value != null && value.trim().length() > 0 ? value : "org.jboss.modules");
        for (String dep : defaultDependencies) {
            if (moduleDeps.indexOf(dep) >= 0) continue;
            moduleDeps.append("," + dep);
        }
        if (Boolean.valueOf(System.getProperty("jboss.arquillian.jsfunit", "false")).booleanValue()) {
            for (String dep : jsfDependencies) {
                if (moduleDeps.indexOf(dep) >= 0) continue;
                moduleDeps.append("," + dep);
            }
        }
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath path = ArchivePaths.create((String)"META-INF", (String)"MANIFEST.MF");
        appArchive.add(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, path);
    }

    static {
        defaultDependencies.add("org.jboss.arquillian.api");
        defaultDependencies.add("org.jboss.arquillian.junit");
        defaultDependencies.add("org.jboss.arquillian.protocol.jmx");
        defaultDependencies.add("org.jboss.arquillian.spi");
        defaultDependencies.add("org.jboss.modules");
        defaultDependencies.add("org.jboss.msc");
        defaultDependencies.add("org.jboss.shrinkwrap.api");
        defaultDependencies.add("org.jboss.shrinkwrap.impl");
        defaultDependencies.add("junit.junit");
        jsfDependencies = new ArrayList<String>();
        jsfDependencies.add("org.jboss.jsfunit.arquillian");
        jsfDependencies.add("org.jboss.jsfunit.core");
    }
}

