/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.arquillian.container.test.spi.client.deployment.ApplicationArchiveProcessor;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.as.arquillian.container.ManifestUtils;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.container.ManifestContainer;

public class ModuleApplicationArchiveProcessor
implements ApplicationArchiveProcessor {
    private static final Logger log = Logger.getLogger(ModuleApplicationArchiveProcessor.class);
    static final List<String> defaultDependencies = new ArrayList<String>();

    public void process(Archive<?> appArchive, TestClass testClass) {
        String value;
        if (!(appArchive instanceof ManifestContainer)) {
            throw new IllegalArgumentException("ManifestContainer expected " + appArchive);
        }
        final Manifest manifest = ManifestUtils.getOrCreateManifest(appArchive);
        Attributes attributes = manifest.getMainAttributes();
        if (attributes.getValue(Attributes.Name.MANIFEST_VERSION.toString()) == null) {
            attributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        }
        StringBuffer moduleDeps = new StringBuffer((value = attributes.getValue("Dependencies")) != null && value.trim().length() > 0 ? value : "org.jboss.modules");
        for (String dep : defaultDependencies) {
            if (moduleDeps.indexOf(dep) >= 0) continue;
            moduleDeps.append("," + dep);
        }
        log.debugf("Add dependencies: %s", (Object)moduleDeps);
        attributes.putValue("Dependencies", moduleDeps.toString());
        ArchivePath manifestPath = ArchivePaths.create((String)"META-INF/MANIFEST.MF");
        appArchive.delete(manifestPath);
        appArchive.add(new Asset(){

            public InputStream openStream() {
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    manifest.write(baos);
                    return new ByteArrayInputStream(baos.toByteArray());
                }
                catch (IOException ex) {
                    throw new IllegalStateException("Cannot write manifest", ex);
                }
            }
        }, manifestPath);
    }

    static {
        defaultDependencies.add("deployment.arquillian-service");
        defaultDependencies.add("org.jboss.modules");
        defaultDependencies.add("org.jboss.msc");
    }
}

