/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.InetAddress;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.ArchiveDeployer;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.util.NotImplementedException;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    private T containerConfig;
    private ManagementClient managementClient;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-as7");
    }

    public void setup(T config) {
        this.containerConfig = config;
        ModelControllerClient modelControllerClient = ModelControllerClient.Factory.create((InetAddress)((CommonContainerConfiguration)config).getManagementAddress(), (int)((CommonContainerConfiguration)config).getManagementPort());
        this.managementClient = new ManagementClient(modelControllerClient);
        this.archiveDeployerInst.set((Object)new ArchiveDeployer(ServerDeploymentManager.Factory.create((ModelControllerClient)modelControllerClient)));
    }

    public final void start() throws LifecycleException {
        this.startInternal();
    }

    protected abstract void startInternal() throws LifecycleException;

    public final void stop() throws LifecycleException {
        this.stopInternal();
    }

    protected abstract void stopInternal() throws LifecycleException;

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        String runtimeName = archiveDeployer.deploy(archive);
        return this.managementClient.getDeploymentMetaData(runtimeName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        archiveDeployer.undeploy(archive.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }
}

