/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.container.ContainerConfiguration;

public class CommonContainerConfiguration
implements ContainerConfiguration {
    private InetAddress managementAddress = this.getInetAddress("127.0.0.1");
    private int managementPort = 9999;
    private String username;
    private String password;

    public InetAddress getManagementAddress() {
        return this.managementAddress;
    }

    public void setManagementAddress(String host) {
        this.managementAddress = this.getInetAddress(host);
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public void setManagementPort(int managementPort) {
        this.managementPort = managementPort;
    }

    private InetAddress getInetAddress(String name) {
        try {
            return InetAddress.getByName(name);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Unknown host: " + name);
        }
    }

    public String getUsername() {
        return this.username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void validate() throws ConfigurationException {
        if (this.username != null && this.password == null) {
            throw new ConfigurationException("username has been set, but no password given");
        }
    }
}

