/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.arquillian.container.spi.client.container.DeployableContainer;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.client.protocol.ProtocolDescription;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.ArchiveDeployer;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.descriptor.api.Descriptor;
import org.jboss.util.NotImplementedException;

public abstract class CommonDeployableContainer<T extends CommonContainerConfiguration>
implements DeployableContainer<T> {
    private static final String JBOSS_URL_PKG_PREFIX = "org.jboss.ejb.client.naming";
    private final Logger log = Logger.getLogger(CommonDeployableContainer.class.getName());
    private T containerConfig;
    private ManagementClient managementClient;
    @Inject
    @ContainerScoped
    private InstanceProducer<ArchiveDeployer> archiveDeployerInst;
    @Inject
    @ApplicationScoped
    private InstanceProducer<Context> jndiContext;
    @Inject
    @ContainerScoped
    private InstanceProducer<ManagementClient> managementClientInst;

    public ProtocolDescription getDefaultProtocol() {
        return new ProtocolDescription("jmx-as7");
    }

    public void setup(T config) {
        this.containerConfig = config;
    }

    public final void start() throws LifecycleException {
        if (((CommonContainerConfiguration)this.containerConfig).getUsername() != null) {
            Authentication.username = ((CommonContainerConfiguration)this.containerConfig).getUsername();
            Authentication.password = ((CommonContainerConfiguration)this.containerConfig).getPassword();
        }
        ModelControllerClient modelControllerClient = null;
        try {
            modelControllerClient = ModelControllerClient.Factory.create((String)((CommonContainerConfiguration)this.containerConfig).getManagementAddress(), (int)((CommonContainerConfiguration)this.containerConfig).getManagementPort(), (CallbackHandler)Authentication.getCallbackHandler());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        this.managementClient = new ManagementClient(modelControllerClient, ((CommonContainerConfiguration)this.containerConfig).getManagementAddress(), ((CommonContainerConfiguration)this.containerConfig).getManagementPort());
        this.managementClientInst.set((Object)this.managementClient);
        this.archiveDeployerInst.set((Object)new ArchiveDeployer(ServerDeploymentManager.Factory.create((ModelControllerClient)modelControllerClient)));
        try {
            Properties jndiProps = new Properties();
            jndiProps.setProperty("java.naming.factory.url.pkgs", JBOSS_URL_PKG_PREFIX);
            this.jndiContext.set((Object)new InitialContext(jndiProps));
        }
        catch (NamingException ne) {
            throw new LifecycleException("Could not set JNDI Naming Context", (Throwable)ne);
        }
        try {
            this.startInternal();
        }
        catch (LifecycleException e) {
            this.safeCloseClient();
            throw e;
        }
    }

    protected abstract void startInternal() throws LifecycleException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws LifecycleException {
        try {
            this.stopInternal();
        }
        finally {
            this.safeCloseClient();
        }
    }

    protected abstract void stopInternal() throws LifecycleException;

    protected T getContainerConfiguration() {
        return this.containerConfig;
    }

    protected ManagementClient getManagementClient() {
        return this.managementClient;
    }

    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    public ProtocolMetaData deploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        String runtimeName = archiveDeployer.deploy(archive);
        return this.managementClient.getDeploymentMetaData(runtimeName);
    }

    public void undeploy(Archive<?> archive) throws DeploymentException {
        ArchiveDeployer archiveDeployer = (ArchiveDeployer)this.archiveDeployerInst.get();
        archiveDeployer.undeploy(archive.getName());
    }

    public void deploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    public void undeploy(Descriptor descriptor) throws DeploymentException {
        throw new NotImplementedException();
    }

    private void safeCloseClient() {
        try {
            this.managementClient.close();
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Caught exception closing ModelControllerClient", e);
        }
    }
}

