/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed.clustering;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.managed.clustering.ManagedContainerConfiguration;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public final class ManagedDeployableContainer
extends CommonDeployableContainer<ManagedContainerConfiguration> {
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class.getName());
    private Thread shutdownThread;
    private Process process;

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    public void setup(ManagedContainerConfiguration config) {
        super.setup((CommonContainerConfiguration)config);
    }

    protected void startInternal() throws LifecycleException {
        try {
            ManagedContainerConfiguration config = (ManagedContainerConfiguration)this.getContainerConfiguration();
            String jbossHomeDir = config.getJbossHome();
            String additionalJavaOpts = System.getProperty("jboss.options");
            String modulePath = config.getModulePath() != null && !config.getModulePath().isEmpty() ? config.getModulePath() : jbossHomeDir + "/modules";
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("java");
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/standalone/log/boot.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/standalone/configuration/logging.properties");
            cmd.add("-Djboss.modules.dir=" + modulePath);
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulePath);
            cmd.add("-logmodule");
            cmd.add("org.jboss.logmanager");
            cmd.add("-jaxpmodule");
            cmd.add("javax.xml.jaxp-provider");
            cmd.add("org.jboss.as.standalone");
            cmd.add("-server-config");
            cmd.add(config.getServerConfig());
            cmd.add("-Djava.net.preferIPv4Stack=true");
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.isServerStarted();
                if (serverAvailable) continue;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
    }

    private boolean isServerStarted() {
        try {
            ModelNode op = Util.getEmptyOperation((String)"read-attribute", (ModelNode)PathAddress.EMPTY_ADDRESS.toModelNode());
            op.get("name").set("server-state");
            ModelNode rsp = this.getModelControllerClient().execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !ControlledProcessState.State.STARTING.toString().equals(rsp.get("result").asString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDeployableContainer.this.process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stream);
            boolean writeOutput = ((ManagedContainerConfiguration)ManagedDeployableContainer.this.getContainerConfiguration()).isOutputToConsole();
            char[] data = new char[100];
            try {
                int read = 0;
                while (read != -1) {
                    if (writeOutput) {
                        System.out.print(data);
                    }
                    read = reader.read(data);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

