/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain.managed;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.arquillian.container.Authentication;
import org.jboss.as.arquillian.container.domain.managed.JBossAsManagedConfiguration;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.client.helpers.domain.DomainClient;
import org.jboss.as.controller.client.helpers.domain.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.sasl.util.UsernamePasswordHashUtil;
import org.xnio.IoUtils;

public class DomainLifecycleUtil {
    private static final ThreadFactory threadFactory = new AsyncThreadFactory();
    private final Logger log = Logger.getLogger(DomainLifecycleUtil.class.getName());
    private Process process;
    private Thread shutdownThread;
    private final JBossAsManagedConfiguration configuration;
    private DomainClient domainClient;
    private Map<ServerIdentity, ControlledProcessState.State> serverStatuses = new HashMap<ServerIdentity, ControlledProcessState.State>();
    private ExecutorService executor;

    public DomainLifecycleUtil(JBossAsManagedConfiguration configuration) {
        assert (configuration != null) : "configuration is null";
        this.configuration = configuration;
    }

    public void start() {
        try {
            String domainDirectory;
            this.configuration.validate();
            String jbossHomeDir = this.configuration.getJbossHome();
            String additionalJavaOpts = System.getProperty("jboss.options");
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            String javaHome = this.configuration.getJavaHome();
            String java = javaHome != null ? javaHome + "/bin/java" : "java";
            File domainDir = this.configuration.getDomainDirectory() != null ? new File(this.configuration.getDomainDirectory()) : new File(new File(jbossHomeDir), "domain");
            String domainPath = domainDir.getAbsolutePath();
            String modulePath = this.configuration.getModulePath() != null && !this.configuration.getModulePath().isEmpty() ? this.configuration.getModulePath() : jbossHomeDir + "/modules";
            File usersFile = new File(domainPath + "/configuration/mgmt-users.properties");
            FileOutputStream fos = new FileOutputStream(usersFile);
            PrintWriter pw = new PrintWriter(fos);
            pw.println("testUser=" + new UsernamePasswordHashUtil().generateHashedHexURP("testUser", "ManagementRealm", "test_user_password".toCharArray()));
            pw.println("slave=" + new UsernamePasswordHashUtil().generateHashedHexURP("slave", "ManagementRealm", "slave_user_password".toCharArray()));
            pw.close();
            fos.close();
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java);
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/process-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulePath);
            cmd.add("-logmodule");
            cmd.add("org.jboss.logmanager");
            cmd.add("org.jboss.as.process-controller");
            cmd.add("-jboss-home");
            cmd.add(jbossHomeDir);
            cmd.add("-jvm");
            cmd.add(java);
            cmd.add("--");
            cmd.add("-Dorg.jboss.boot.log.file=" + domainPath + "/log/host-controller.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/domain/configuration/logging.properties");
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("--");
            cmd.add("-default-jvm");
            cmd.add(java);
            if (this.configuration.getHostCommandLineProperties() != null) {
                for (String opt : this.configuration.getHostCommandLineProperties().split("\\s+")) {
                    cmd.add(opt);
                }
            }
            if ((domainDirectory = this.configuration.getDomainDirectory()) != null) {
                cmd.add("-Djboss.domain.base.dir=" + domainDirectory);
            } else {
                domainDirectory = domainPath;
            }
            if (this.configuration.getDomainConfigFile() != null) {
                String name = this.copyConfigFile(new File(this.configuration.getDomainConfigFile()), new File(domainDirectory, "configuration"));
                cmd.add("-domain-config");
                cmd.add(name);
            }
            if (this.configuration.getHostConfigFile() != null) {
                String name = this.copyConfigFile(new File(this.configuration.getHostConfigFile()), new File(domainDirectory, "configuration"));
                cmd.add("-host-config");
                cmd.add(name);
            }
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            long start = System.currentTimeMillis();
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long timeout = this.configuration.getStartupTimeoutInSeconds() * 1000;
            boolean serversAvailable = false;
            while (timeout > 0L && !serversAvailable) {
                serversAvailable = this.areServersStarted();
                if (serversAvailable) continue;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (!serversAvailable) {
                throw new TimeoutException(String.format("Managed servers were not started within [%d] seconds", this.configuration.getStartupTimeoutInSeconds()));
            }
            this.log.info("All servers started in " + (System.currentTimeMillis() - start) + " ms");
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start container", e);
        }
    }

    public Future<Void> startAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.start();
                return null;
            }
        };
        return this.getExecutorService().submit(c);
    }

    public void stop() {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not stop container", e);
        }
        finally {
            this.safeCloseDomainClient();
            ExecutorService exec = this.executor;
            if (exec != null) {
                exec.shutdownNow();
                this.executor = null;
            }
        }
    }

    public Future<Void> stopAsync() {
        Callable<Void> c = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                DomainLifecycleUtil.this.stop();
                return null;
            }
        };
        return Executors.newSingleThreadExecutor(threadFactory).submit(c);
    }

    public synchronized DomainClient getDomainClient() {
        if (this.domainClient == null) {
            try {
                InetAddress managementAddress = InetAddress.getByName(this.configuration.getHostControllerManagementAddress());
                this.domainClient = DomainClient.Factory.create((InetAddress)managementAddress, (int)this.configuration.getHostControllerManagementPort(), (CallbackHandler)Authentication.getCallbackHandler());
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        return this.domainClient;
    }

    private synchronized ExecutorService getExecutorService() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor(threadFactory);
        }
        return this.executor;
    }

    private boolean areServersStarted() {
        try {
            Map<ServerIdentity, ControlledProcessState.State> statuses = this.getServerStatuses();
            block5: for (Map.Entry<ServerIdentity, ControlledProcessState.State> entry : statuses.entrySet()) {
                switch (entry.getValue()) {
                    case RUNNING: {
                        continue block5;
                    }
                }
                return false;
            }
            this.serverStatuses.putAll(statuses);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private synchronized void safeCloseDomainClient() {
        if (this.domainClient != null) {
            try {
                this.domainClient.close();
            }
            catch (IOException e) {
                this.log.log(Level.SEVERE, "Caught exception closing DomainClient", e);
            }
        }
    }

    private Map<ServerIdentity, ControlledProcessState.State> getServerStatuses() {
        HashMap<ServerIdentity, ControlledProcessState.State> result = new HashMap<ServerIdentity, ControlledProcessState.State>();
        ModelNode op = new ModelNode();
        op.get("operation").set("read-children-names");
        op.get("child-type").set("server-config");
        op.get("address").add("host", this.configuration.getHostName());
        ModelNode opResult = this.executeForResult(new OperationBuilder(op).build());
        HashSet<String> servers = new HashSet<String>();
        for (ModelNode modelNode : opResult.asList()) {
            servers.add(modelNode.asString());
        }
        for (String string : servers) {
            ModelNode address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            address.add("server-config", string);
            String group = this.readAttribute("group", address).asString();
            if (!this.readAttribute("auto-start", address).asBoolean()) continue;
            address = new ModelNode();
            address.add("host", this.configuration.getHostName());
            address.add("server", string);
            ControlledProcessState.State status = Enum.valueOf(ControlledProcessState.State.class, this.readAttribute("server-state", address).asString().toUpperCase());
            ServerIdentity id = new ServerIdentity(this.configuration.getHostName(), group, string);
            result.put(id, status);
        }
        return result;
    }

    private ModelNode readAttribute(String name, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set("read-attribute");
        op.get("address").set(address);
        op.get("name").set(name);
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private ModelNode executeForResult(ModelNode op) {
        return this.executeForResult(new OperationBuilder(op).build());
    }

    private ModelNode executeForResult(Operation op) {
        try {
            ModelNode result = this.getDomainClient().execute(op);
            if (result.hasDefined("outcome") && "success".equals(result.get("outcome").asString())) {
                return result.get("result");
            }
            if (result.hasDefined("failure-description")) {
                throw new RuntimeException(result.get("failure-description").toString());
            }
            if (result.hasDefined("domain-failure-description")) {
                throw new RuntimeException(result.get("domain-failure-description").toString());
            }
            if (result.hasDefined("host-failure-descriptions")) {
                throw new RuntimeException(result.get("host-failure-descriptions").toString());
            }
            throw new RuntimeException("Operation outcome is " + result.get("outcome").asString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        DomainLifecycleUtil starterUtil = new DomainLifecycleUtil(new JBossAsManagedConfiguration());
        starterUtil.start();
        System.out.println("--------- STARTED");
        starterUtil.stop();
        System.out.println("--------- STOPPED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String copyConfigFile(File file, File dir) {
        File newFile = new File(dir, "testing-" + file.getName());
        if (newFile.exists()) {
            newFile.delete();
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newFile));
                try {
                    int i = ((InputStream)in).read();
                    while (i != -1) {
                        ((OutputStream)out).write(i);
                        i = ((InputStream)in).read();
                    }
                }
                finally {
                    IoUtils.safeClose((Closeable)out);
                }
            }
            finally {
                IoUtils.safeClose((Closeable)in);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newFile.getName();
    }

    private static final class AsyncThreadFactory
    implements ThreadFactory {
        private int threadCount;

        private AsyncThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, DomainLifecycleUtil.class.getSimpleName() + "-" + ++this.threadCount);
            t.setDaemon(true);
            return t;
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = DomainLifecycleUtil.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String val = System.getProperty("org.jboss.as.writeconsole");
                    return val == null || !"false".equals(val);
                }
            });
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

