/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.arquillian.container.spi.context.annotation.ContainerScoped;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.MBeanServerConnectionProvider;
import org.jboss.as.arquillian.container.managed.ManagedContainerConfiguration;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.jboss.sasl.JBossSaslProvider;

public final class ManagedDeployableContainer
extends CommonDeployableContainer<ManagedContainerConfiguration> {
    private final Logger log = Logger.getLogger(ManagedDeployableContainer.class.getName());
    private MBeanServerConnectionProvider provider;
    private Thread shutdownThread;
    private Process process;
    private Provider saslProvider = new JBossSaslProvider();
    @Inject
    @ContainerScoped
    private InstanceProducer<MBeanServerConnection> mbeanServerInst;

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public Class<ManagedContainerConfiguration> getConfigurationClass() {
        return ManagedContainerConfiguration.class;
    }

    public void setup(ManagedContainerConfiguration config) {
        super.setup((CommonContainerConfiguration)config);
        this.provider = new MBeanServerConnectionProvider(config.getBindAddress(), config.getJmxPort());
    }

    protected void startInternal() throws LifecycleException {
        Security.addProvider(this.saslProvider);
        try {
            if (this.isServerStarted()) {
                this.mbeanServerInst.set((Object)this.getMBeanServerConnection(5000L));
                return;
            }
            ManagedContainerConfiguration config = (ManagedContainerConfiguration)this.getContainerConfiguration();
            String jbossHomeDir = config.getJbossHome();
            String modulePath = config.getModulePath() != null && !config.getModulePath().isEmpty() ? config.getModulePath() : jbossHomeDir + "/modules";
            String additionalJavaOpts = System.getProperty("jboss.options");
            File modulesJar = new File(jbossHomeDir + "/jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("java");
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/standalone/log/boot.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + "/standalone/configuration/logging.properties");
            cmd.add("-Djboss.modules.dir=" + modulePath);
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulePath);
            cmd.add("-logmodule");
            cmd.add("org.jboss.logmanager");
            cmd.add("-jaxpmodule");
            cmd.add("javax.xml.jaxp-provider");
            cmd.add("org.jboss.as.standalone");
            cmd.add("-server-config");
            cmd.add(config.getServerConfig());
            this.log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.isServerStarted();
                if (serverAvailable) continue;
                Thread.sleep(100L);
                timeout -= 100L;
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed server was not started within [%d] ms", ((ManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeout()));
            }
            this.mbeanServerInst.set((Object)this.getMBeanServerConnection(5000L));
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected void stopInternal() throws LifecycleException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new LifecycleException("Could not stop container", (Throwable)e);
        }
        Security.removeProvider(this.saslProvider.getName());
    }

    protected MBeanServerConnection getMBeanServerConnection() {
        return this.provider.getConnection();
    }

    private boolean isServerStarted() {
        try {
            ModelNode op = Util.getEmptyOperation((String)"read-attribute", (ModelNode)PathAddress.EMPTY_ADDRESS.toModelNode());
            op.get("name").set("server-state");
            ModelNode rsp = this.getModelControllerClient().execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !ControlledProcessState.State.STARTING.toString().equals(rsp.get("result").asString()) && !ControlledProcessState.State.STOPPING.toString().equals(rsp.get("result").asString());
        }
        catch (Exception exception) {
            return false;
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = ManagedDeployableContainer.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    String val = System.getProperty("org.jboss.as.writeconsole");
                    return val == null || !"false".equals(val);
                }
            });
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

