/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import java.util.ArrayList;
import java.util.Scanner;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;

public class ManagedContainerConfiguration
extends CommonContainerConfiguration {
    private static final Integer DEFAULT_VALUE_WAIT_FOR_PORTS_TIMEOUT_SECONDS = 10;
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String modulePath = System.getProperty("module.path");
    private String bundlePath = System.getProperty("bundle.path");
    private String javaVmArguments = System.getProperty("jboss.options", "-Xmx512m -XX:MaxPermSize=128m");
    private int startupTimeoutInSeconds = 60;
    private boolean outputToConsole = true;
    private String serverConfig = System.getProperty("jboss.server.config.file.name", "standalone.xml");
    private boolean allowConnectingToRunningServer = Boolean.parseBoolean(System.getProperty("allowConnectingToRunningServer", "false"));
    private boolean enableAssertions = true;
    private boolean adminOnly = false;
    private Integer[] waitForPorts;
    private Integer waitForPortsTimeoutInSeconds;

    public ManagedContainerConfiguration() {
        if (this.javaHome == null || this.javaHome.isEmpty()) {
            this.javaHome = System.getProperty("java.home");
        }
        if (this.jbossHome == null || this.jbossHome.isEmpty()) {
            this.jbossHome = System.getProperty("jboss.home");
        }
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome '" + this.jbossHome + "' must exist"));
        if (this.javaHome != null) {
            Validate.configurationDirectoryExists((String)this.javaHome, (String)"javaHome must exist");
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getBundlePath() {
        return this.bundlePath;
    }

    public void setBundlePath(String bundlePath) {
        this.bundlePath = bundlePath;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public void setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public Integer[] getWaitForPorts() {
        return this.waitForPorts;
    }

    public void setWaitForPorts(String waitForPorts) {
        Scanner scanner = new Scanner(waitForPorts);
        ArrayList<Integer> list = new ArrayList<Integer>();
        while (scanner.hasNextInt()) {
            list.add(scanner.nextInt());
        }
        this.waitForPorts = list.toArray(new Integer[0]);
    }

    public Integer getWaitForPortsTimeoutInSeconds() {
        return this.waitForPortsTimeoutInSeconds != null ? this.waitForPortsTimeoutInSeconds : DEFAULT_VALUE_WAIT_FOR_PORTS_TIMEOUT_SECONDS;
    }

    public void setWaitForPortsTimeoutInSeconds(Integer waitForPortsTimeoutInSeconds) {
        this.waitForPortsTimeoutInSeconds = waitForPortsTimeoutInSeconds;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }
}

