/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.List;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.DotName;
import org.jboss.logging.Logger;
import org.junit.runner.RunWith;

public class ArquillianConfigBuilder {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");

    ArquillianConfigBuilder(DeploymentUnit deploymentUnit) {
    }

    static ArquillianConfig processDeployment(ArquillianService arqService, DeploymentUnit depUnit) {
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)depUnit);
            return null;
        }
        DotName runWithName = DotName.createSimple((String)RunWith.class.getName());
        List runWithList = compositeIndex.getAnnotations(runWithName);
        if (runWithList.isEmpty()) {
            return null;
        }
        ArquillianConfig arqConfig = new ArquillianConfig(arqService, depUnit, runWithList);
        if (arqService.getServiceContainer().getService(arqConfig.getServiceName()) != null) {
            log.warnf("Arquillian config already registered: %s", (Object)arqConfig);
            return null;
        }
        depUnit.putAttachment(ArquillianConfig.KEY, (Object)arqConfig);
        return arqConfig;
    }
}

