/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.List;
import javax.inject.Inject;
import org.jboss.as.arquillian.service.ArquillianConfig;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceContainer;

public class FrameworkActivationProcessor {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.arquillian");

    static void process(ServiceContainer serviceContainer, ServiceBuilder<ArquillianConfig> builder, ArquillianConfig arqConfig) {
        DeploymentUnit depUnit = arqConfig.getDeploymentUnit();
        CompositeIndex compositeIndex = (CompositeIndex)depUnit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            log.warnf("Cannot find composite annotation index in: %s", (Object)depUnit);
            return;
        }
        DotName dotName = DotName.createSimple((String)Inject.class.getName());
        List annotationList = compositeIndex.getAnnotations(dotName);
        if (annotationList.isEmpty()) {
            return;
        }
        for (AnnotationInstance instance : annotationList) {
            FieldInfo fieldInfo;
            String typeName;
            AnnotationTarget target = instance.target();
            if (!(target instanceof FieldInfo) || !(typeName = (fieldInfo = (FieldInfo)target).type().toString()).startsWith("org.osgi.framework")) continue;
            log.debugf("OSGi injection point of type '%s' detected: %s", (Object)typeName, (Object)fieldInfo.declaringClass());
            arqConfig.addFrameworkDependency(builder);
            break;
        }
    }
}

