/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class Util {
    public static boolean isSuccess(ModelNode operationResult) {
        if (operationResult != null) {
            ModelNode outcome = operationResult.get("outcome");
            return outcome != null && outcome.asString().equals("success");
        }
        return false;
    }

    public static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    public static List<String> getRequestPropertyNames(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        ModelNode result = operationResult.get("result");
        if (!result.hasDefined("request-properties")) {
            return Collections.emptyList();
        }
        List nodeList = result.get("request-properties").asPropertyList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (Property node : nodeList) {
            list.add(node.getName());
        }
        return list;
    }
}

