/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.controller.client.ModelControllerClient;

public class ConnectHandler
implements CommandHandler {
    @Override
    public void handle(CommandContext ctx) {
        int port = 9999;
        String host = "localhost";
        String args = ctx.getCommandArguments();
        if (args != null) {
            String portStr = null;
            int colonIndex = args.indexOf(58);
            if (colonIndex < 0) {
                host = args;
            } else if (colonIndex == 0) {
                portStr = args.substring(1).trim();
            } else {
                host = args.substring(0, colonIndex).trim();
                portStr = args.substring(colonIndex + 1).trim();
            }
            if (portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    ctx.log("The port must be a valid non-negative integer: '" + args + "'");
                    port = -1;
                }
            }
        }
        if (port >= 0) {
            try {
                ModelControllerClient client = ModelControllerClient.Factory.create((InetAddress)InetAddress.getByName(host), (int)port);
                ctx.setModelControllerClient(client);
                ctx.log("Connected to " + host + ":" + port);
            }
            catch (UnknownHostException e) {
                ctx.log("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        }
    }
}

