/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;

public class ConnectHandler
extends CommandHandlerWithHelp {
    public ConnectHandler() {
        this("connect");
    }

    public ConnectHandler(String command) {
        super(command);
    }

    @Override
    protected void handle(CommandContext ctx, String args) {
        int port = -1;
        String host = null;
        if (args != null) {
            String portStr = null;
            int colonIndex = args.indexOf(58);
            if (colonIndex < 0) {
                host = args;
            } else if (colonIndex == 0) {
                portStr = args.substring(1).trim();
            } else {
                host = args.substring(0, colonIndex).trim();
                portStr = args.substring(colonIndex + 1).trim();
            }
            if (portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    ctx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                    return;
                }
                if (port < 0) {
                    ctx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                    return;
                }
            }
        }
        ctx.connectController(host, port);
    }
}

