/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.batch.impl.DefaultBatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatchedCommand;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.CreateJmsCFHandler;
import org.jboss.as.cli.handlers.CreateJmsQueueHandler;
import org.jboss.as.cli.handlers.CreateJmsResourceHandler;
import org.jboss.as.cli.handlers.CreateJmsTopicHandler;
import org.jboss.as.cli.handlers.DeleteJmsCFHandler;
import org.jboss.as.cli.handlers.DeleteJmsQueueHandler;
import org.jboss.as.cli.handlers.DeleteJmsResourceHandler;
import org.jboss.as.cli.handlers.DeleteJmsTopicHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.handlers.batch.BatchClearHandler;
import org.jboss.as.cli.handlers.batch.BatchDiscardHandler;
import org.jboss.as.cli.handlers.batch.BatchEditLineHandler;
import org.jboss.as.cli.handlers.batch.BatchHandler;
import org.jboss.as.cli.handlers.batch.BatchHoldbackHandler;
import org.jboss.as.cli.handlers.batch.BatchListHandler;
import org.jboss.as.cli.handlers.batch.BatchMoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRemoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRunHandler;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.PrefixFormatter;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;

public class CommandLineMain {
    private static final CommandRegistry cmdRegistry = new CommandRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ConsoleReader console = CommandLineMain.initConsoleReader();
        final CommandContextImpl cmdCtx = new CommandContextImpl(console);
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        console.addCompletor((Completor)cmdCtx.cmdCompleter);
        String[] commands = null;
        String fileName = null;
        boolean connect = false;
        for (String arg : args) {
            if (arg.startsWith("controller=")) {
                String value = arg.substring(11);
                String portStr = null;
                int colonIndex = value.indexOf(58);
                if (colonIndex < 0) {
                    cmdCtx.defaultControllerHost = value;
                } else if (colonIndex == 0) {
                    portStr = value.substring(1);
                } else {
                    cmdCtx.defaultControllerHost = value.substring(0, colonIndex);
                    portStr = value.substring(colonIndex + 1);
                }
                if (portStr == null) continue;
                int port = -1;
                try {
                    port = Integer.parseInt(portStr);
                    if (port < 0) {
                        cmdCtx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                        continue;
                    }
                    cmdCtx.defaultControllerPort = port;
                }
                catch (NumberFormatException e) {
                    cmdCtx.printLine("The port must be a valid non-negative integer: '" + arg + "'");
                }
                continue;
            }
            if ("--connect".equals(arg)) {
                connect = true;
                continue;
            }
            if (arg.startsWith("file=")) {
                fileName = arg.substring(5);
                continue;
            }
            if (arg.startsWith("commands=")) {
                commands = arg.substring(9).split(",+");
                continue;
            }
            if (!arg.startsWith("command=")) continue;
            commands = new String[]{arg.substring(8)};
        }
        if (connect) {
            cmdCtx.connectController(null, -1);
        } else {
            cmdCtx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
        }
        if (fileName != null && !fileName.isEmpty()) {
            File f = new File(fileName);
            if (!f.exists()) {
                cmdCtx.printLine("File " + f.getAbsolutePath() + " doesn't exist.");
            } else {
                BufferedReader reader = new BufferedReader(new FileReader(f));
                try {
                    String line = reader.readLine();
                    while (!cmdCtx.terminate && line != null) {
                        CommandLineMain.processLine(cmdCtx, line.trim());
                        line = reader.readLine();
                    }
                }
                finally {
                    StreamUtils.safeClose((Closeable)reader);
                    if (!cmdCtx.terminate) {
                        cmdCtx.terminateSession();
                    }
                    cmdCtx.disconnectController();
                }
                return;
            }
        }
        if (commands != null) {
            for (int i = 0; i < commands.length && !cmdCtx.terminate; ++i) {
                CommandLineMain.processLine(cmdCtx, (String)commands[i]);
            }
            if (!cmdCtx.terminate) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController();
            return;
        }
        try {
            while (!cmdCtx.terminate) {
                String line = console.readLine(cmdCtx.getPrompt()).trim();
                CommandLineMain.processLine(cmdCtx, line);
            }
        }
        finally {
            cmdCtx.disconnectController();
        }
    }

    protected static void processLine(CommandContextImpl cmdCtx, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (CommandLineMain.isOperation(line)) {
            cmdCtx.setArgs(null, line);
            if (cmdCtx.isBatchMode()) {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(cmdCtx.getPrefix());
                try {
                    cmdCtx.getOperationRequestParser().parse(line, builder);
                    ModelNode request = builder.buildRequest();
                    StringBuilder op = new StringBuilder();
                    op.append(cmdCtx.getPrefixFormatter().format(builder.getAddress()));
                    op.append(line.substring(line.indexOf(58)));
                    cmdCtx.getBatchManager().getActiveBatch().getCommands().add(new DefaultBatchedCommand(op.toString(), request));
                }
                catch (CommandFormatException e) {
                    cmdCtx.printLine(e.getLocalizedMessage());
                }
            } else {
                cmdCtx.operationHandler.handle(cmdCtx);
            }
        } else {
            String cmd = line;
            String cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
                break;
            }
            cmdCtx.setArgs(cmd, cmdArgs);
            CommandHandler handler = cmdRegistry.getCommandHandler(cmd.toLowerCase());
            if (handler != null) {
                if (cmdCtx.isBatchMode() && handler.isBatchMode()) {
                    if (!(handler instanceof OperationCommand)) {
                        cmdCtx.printLine("The command is not allowed in a batch.");
                    } else {
                        try {
                            ModelNode request = ((OperationCommand)handler).buildRequest(cmdCtx);
                            DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(line, request);
                            cmdCtx.getBatchManager().getActiveBatch().add(batchedCmd);
                        }
                        catch (OperationFormatException e) {
                            cmdCtx.printLine("Failed to add to batch: " + e.getLocalizedMessage());
                        }
                    }
                } else {
                    handler.handle(cmdCtx);
                }
            } else {
                cmdCtx.printLine("Unexpected command '" + line + "'. Type 'help' for the list of supported commands.");
            }
        }
    }

    protected static ConsoleReader initConsoleReader() {
        String osName = SecurityActions.getSystemProperty("os.name").toLowerCase();
        String bindingsName = osName.indexOf("windows") >= 0 ? "keybindings/jline-windows-bindings.properties" : (osName.startsWith("mac") ? "keybindings/jline-mac-bindings.properties" : "keybindings/jline-default-bindings.properties");
        ClassLoader cl = SecurityActions.getClassLoader(CommandLineMain.class);
        InputStream bindingsIs = cl.getResourceAsStream(bindingsName);
        if (bindingsIs == null) {
            System.err.println("Failed to locate key bindings for OS '" + osName + "': " + bindingsName);
            try {
                return new ConsoleReader();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize console reader", e);
            }
        }
        try {
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            String encoding = SecurityActions.getSystemProperty("jline.WindowsTerminal.output.encoding");
            if (encoding == null) {
                encoding = SecurityActions.getSystemProperty("file.encoding");
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
            ConsoleReader consoleReader = new ConsoleReader((InputStream)in, (Writer)out, bindingsIs);
            return consoleReader;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize console reader", e);
        }
        finally {
            StreamUtils.safeClose((Closeable)bindingsIs);
        }
    }

    private static boolean isOperation(String line) {
        char firstChar = line.charAt(0);
        return firstChar == '.' || firstChar == ':' || firstChar == '/' || line.startsWith("..") || line.startsWith(".type");
    }

    static {
        cmdRegistry.registerHandler((CommandHandler)new HelpHandler(), "help", "h");
        cmdRegistry.registerHandler((CommandHandler)new QuitHandler(), "quit", "q");
        cmdRegistry.registerHandler((CommandHandler)new ConnectHandler(), "connect");
        cmdRegistry.registerHandler((CommandHandler)new PrefixHandler(), "cd", "cn");
        cmdRegistry.registerHandler((CommandHandler)new LsHandler(), "ls");
        cmdRegistry.registerHandler((CommandHandler)new HistoryHandler(), "history");
        cmdRegistry.registerHandler((CommandHandler)new DeployHandler(), "deploy");
        cmdRegistry.registerHandler((CommandHandler)new UndeployHandler(), "undeploy");
        cmdRegistry.registerHandler((CommandHandler)new PrintWorkingNodeHandler(), "pwd", "pwn");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsQueueHandler(), "create-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsQueueHandler(), "delete-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsTopicHandler(), "create-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsTopicHandler(), "delete-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsCFHandler(), "create-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsCFHandler(), "delete-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsResourceHandler(), false, "create-jms-resource");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsResourceHandler(), false, "delete-jms-resource");
        cmdRegistry.registerHandler((CommandHandler)new BatchHandler(), "batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchDiscardHandler(), "discard-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchListHandler(), "list-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchHoldbackHandler(), "holdback-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRunHandler(), "run-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchClearHandler(), "clear-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRemoveLineHandler(), "remove-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchMoveLineHandler(), "move-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchEditLineHandler(), "edit-batch-line");
    }

    private static class CommandContextImpl
    implements CommandContext {
        private final ConsoleReader console;
        private final CommandHistory history;
        private boolean terminate;
        private String cmd;
        private String cmdArgs;
        private Set<String> switches;
        private Map<String, String> namedArgs;
        private List<String> argsList;
        private ModelControllerClient client;
        private String defaultControllerHost = "localhost";
        private int defaultControllerPort = 9999;
        private String controllerHost;
        private int controllerPort = -1;
        private Map<String, Object> map = new HashMap<String, Object>();
        private final OperationRequestParser parser = new DefaultOperationRequestParser();
        private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
        private final PrefixFormatter prefixFormatter = new DefaultPrefixFormatter();
        private final OperationCandidatesProvider operationCandidatesProvider;
        private final OperationRequestHandler operationHandler;
        private BatchManager batchManager = new DefaultBatchManager();
        private final CommandCompleter cmdCompleter;

        private CommandContextImpl(ConsoleReader console) {
            this.console = console;
            console.setUseHistory(true);
            String userHome = SecurityActions.getSystemProperty("user.home");
            File historyFile = new File(userHome, ".jboss-cli-history");
            try {
                console.getHistory().setHistoryFile(historyFile);
            }
            catch (IOException e) {
                System.err.println("Failed to setup the history file " + historyFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            this.history = new HistoryImpl();
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider(this);
            this.operationHandler = new OperationRequestHandler();
            this.cmdCompleter = new CommandCompleter(cmdRegistry, this);
        }

        @Override
        public String getCommandArguments() {
            return this.cmdArgs;
        }

        @Override
        public void terminateSession() {
            this.terminate = true;
        }

        @Override
        public void printLine(String message) {
            try {
                this.console.printString(message);
                this.console.printNewline();
            }
            catch (IOException e) {
                System.err.println("Failed to print '" + message + "' to the console: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void printColumns(Collection<String> col) {
            try {
                this.console.printColumns(col);
            }
            catch (IOException e) {
                System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
            }
        }

        @Override
        public void set(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public OperationRequestParser getOperationRequestParser() {
            return this.parser;
        }

        @Override
        public OperationRequestAddress getPrefix() {
            return this.prefix;
        }

        @Override
        public PrefixFormatter getPrefixFormatter() {
            return this.prefixFormatter;
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.operationCandidatesProvider;
        }

        @Override
        public void connectController(String host, int port) {
            if (host == null) {
                host = this.defaultControllerHost;
            }
            if (port < 0) {
                port = this.defaultControllerPort;
            }
            try {
                ModelControllerClient newClient = ModelControllerClient.Factory.create((String)host, (int)port);
                if (this.client != null) {
                    this.disconnectController();
                }
                this.printLine("Connected to " + host + ":" + port);
                this.client = newClient;
                this.controllerHost = host;
                this.controllerPort = port;
            }
            catch (UnknownHostException e) {
                this.printLine("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        }

        @Override
        public void disconnectController() {
            if (this.client != null) {
                StreamUtils.safeClose((Closeable)this.client);
                this.printLine("Closed connection to " + this.controllerHost + ':' + this.controllerPort);
                this.client = null;
                this.controllerHost = null;
                this.controllerPort = -1;
            }
        }

        @Override
        public String getControllerHost() {
            return this.controllerHost;
        }

        @Override
        public int getControllerPort() {
            return this.controllerPort;
        }

        String getPrompt() {
            StringBuilder buffer = new StringBuilder();
            buffer.append('[');
            if (this.controllerHost != null) {
                buffer.append(this.controllerHost).append(':').append(this.controllerPort).append(' ');
            } else {
                buffer.append("disconnected ");
            }
            if (this.prefix.isEmpty()) {
                buffer.append('/');
            } else {
                String nodeName = this.prefix.getNodeName();
                if (nodeName == null) {
                    buffer.append(this.prefix.getNodeType());
                } else {
                    buffer.append(nodeName);
                }
            }
            if (this.isBatchMode()) {
                buffer.append(" #");
            }
            buffer.append("] ");
            return buffer.toString();
        }

        @Override
        public CommandHistory getHistory() {
            return this.history;
        }

        @Override
        public String getDefaultControllerHost() {
            return this.defaultControllerHost;
        }

        @Override
        public int getDefaultControllerPort() {
            return this.defaultControllerPort;
        }

        @Override
        public boolean hasSwitch(String switchName) {
            if (this.switches == null) {
                this.parseArgs();
            }
            return this.switches.contains(switchName);
        }

        @Override
        public String getNamedArgument(String argName) {
            if (this.namedArgs == null) {
                this.parseArgs();
            }
            return this.namedArgs.get(argName);
        }

        @Override
        public List<String> getArguments() {
            if (this.argsList == null) {
                this.parseArgs();
            }
            return this.argsList;
        }

        @Override
        public boolean hasArguments() {
            return this.cmdArgs != null;
        }

        private void parseArgs() {
            String[] arr;
            this.switches = null;
            this.namedArgs = null;
            this.argsList = null;
            if (this.cmdArgs != null && (arr = this.cmdArgs.split("\\s+")).length > 0) {
                for (int i = 0; i < arr.length; ++i) {
                    String arg = arr[i];
                    if (arg.charAt(0) == '-') {
                        String switchArg = arg.length() > 1 && arg.charAt(1) == '-' ? arg.substring(2) : arg.substring(1);
                        if (switchArg.length() > 0) {
                            if (this.switches == null) {
                                this.switches = new HashSet<String>();
                            }
                            this.switches.add(switchArg);
                            continue;
                        }
                        if (this.argsList == null) {
                            this.argsList = new ArrayList<String>();
                        }
                        this.argsList.add(arg);
                        continue;
                    }
                    if (this.argsList == null) {
                        this.argsList = new ArrayList<String>();
                    }
                    this.argsList.add(arg);
                    int equalsIndex = arg.indexOf(61);
                    if (equalsIndex <= 0 || equalsIndex >= arg.length() - 1 || arg.indexOf(equalsIndex + 1, 61) >= 0) continue;
                    String name = arg.substring(0, equalsIndex).trim();
                    String value = arg.substring(equalsIndex + 1).trim();
                    if (this.namedArgs == null) {
                        this.namedArgs = new HashMap<String, String>();
                    }
                    this.namedArgs.put(name, value);
                }
                if (this.argsList != null) {
                    this.argsList = Collections.unmodifiableList(this.argsList);
                }
            }
            if (this.switches == null) {
                this.switches = Collections.emptySet();
            }
            if (this.namedArgs == null) {
                this.namedArgs = Collections.emptyMap();
            }
            if (this.argsList == null) {
                this.argsList = Collections.emptyList();
            }
        }

        private void setArgs(String cmd, String args) {
            this.cmd = cmd;
            this.cmdArgs = args;
            this.switches = null;
            this.namedArgs = null;
            this.argsList = null;
        }

        @Override
        public Set<String> getArgumentNames() {
            if (this.namedArgs == null) {
                this.parseArgs();
            }
            return this.namedArgs.keySet();
        }

        @Override
        public boolean isBatchMode() {
            return this.batchManager.isBatchActive();
        }

        @Override
        public String getCommand() {
            return this.cmd;
        }

        @Override
        public BatchManager getBatchManager() {
            return this.batchManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BatchedCommand toBatchedCommand(String line) throws OperationFormatException {
            CommandHandler handler;
            if (line.isEmpty()) {
                throw new IllegalArgumentException("Null command line.");
            }
            String originalCommand = this.cmd;
            String originalArguments = this.cmdArgs;
            if (CommandLineMain.isOperation(line)) {
                try {
                    this.setArgs(null, line);
                    DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(this.getPrefix());
                    this.parser.parse(line, builder);
                    ModelNode request = builder.buildRequest();
                    StringBuilder op = new StringBuilder();
                    op.append(this.prefixFormatter.format(builder.getAddress()));
                    op.append(line.substring(line.indexOf(58)));
                    DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(op.toString(), request);
                    return defaultBatchedCommand;
                }
                finally {
                    this.setArgs(originalCommand, originalArguments);
                }
            }
            String cmd = line;
            String cmdArgs = null;
            for (int i = 0; i < cmd.length(); ++i) {
                if (!Character.isWhitespace(cmd.charAt(i))) continue;
                cmdArgs = cmd.substring(i + 1).trim();
                cmd = cmd.substring(0, i);
                break;
            }
            if ((handler = cmdRegistry.getCommandHandler(cmd.toLowerCase())) == null) {
                throw new OperationFormatException("No command handler for '" + cmd + "'.");
            }
            if (!(handler instanceof OperationCommand)) {
                throw new OperationFormatException("The command is not allowed in a batch.");
            }
            try {
                this.setArgs(cmd, cmdArgs);
                ModelNode request = ((OperationCommand)handler).buildRequest(this);
                DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(line, request);
                return defaultBatchedCommand;
            }
            finally {
                this.setArgs(originalCommand, originalArguments);
            }
        }

        @Override
        public CommandLineCompleter getDefaultCommandCompleter() {
            return this.cmdCompleter;
        }

        private class HistoryImpl
        implements CommandHistory {
            private HistoryImpl() {
            }

            @Override
            public List<String> asList() {
                return CommandContextImpl.this.console.getHistory().getHistoryList();
            }

            @Override
            public boolean isUseHistory() {
                return CommandContextImpl.this.console.getUseHistory();
            }

            @Override
            public void setUseHistory(boolean useHistory) {
                CommandContextImpl.this.console.setUseHistory(useHistory);
            }

            @Override
            public void clear() {
                CommandContextImpl.this.console.getHistory().clear();
            }
        }
    }
}

