/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class CreateJmsCFHandler
extends BatchModeCommandHandler {
    public CreateJmsCFHandler() {
        super("create-jms-cf", true, new SimpleTabCompleter(new String[]{"--help", "name=", "auto-group=", "entries=", "connector=", "block-on-acknowledge=", "block-on-durable-send=", "block-on-non-durable-send=", "cache-large-message-client=", "call-timeout=", "client-failure-check-period=", "client-id=", "confirmation-window-size=", "connection-ttl=", "connector=", "consumer-max-rate=", "consumer-window-size=", "discovery-group-name=", "dups-ok-batch-size=", "failover-on-initial-connection=", "failover-on-server-shutdown=", "group-id=", "max-retry-interval=", "min-large-message-size=", "pre-acknowledge=", "producer-max-rate=", "producer-window-size=", "reconnect-attempts=", "retry-interval=", "retry-interval-multiplier=", "scheduled-thread-pool-max-size=", "thread-pool-max-size=", "transaction-batch-size=", "use-global-pools="}));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        ModelNode result;
        ModelNode request;
        try {
            request = this.buildRequest(ctx);
        }
        catch (OperationFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
            return;
        }
        ModelControllerClient client = ctx.getModelControllerClient();
        try {
            result = client.execute(request);
        }
        catch (Exception e) {
            ctx.printLine("Failed to perform operation: " + e.getLocalizedMessage());
            return;
        }
        if (!Util.isSuccess(result)) {
            ctx.printLine(Util.getFailureDescription(result));
            return;
        }
        ctx.printLine("Created connection factory " + ctx.getNamedArgument("name"));
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws OperationFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        builder.addNode("subsystem", "jms");
        builder.setOperationName("add");
        String name = null;
        String entriesStr = null;
        for (String argName : ctx.getArgumentNames()) {
            if (argName.equals("name")) {
                name = ctx.getNamedArgument(argName);
                continue;
            }
            if (argName.equals("entries")) {
                entriesStr = ctx.getNamedArgument(argName);
                continue;
            }
            builder.addProperty(argName, ctx.getNamedArgument(argName));
        }
        if (name == null) {
            throw new OperationFormatException("Required argument 'name' is missing.");
        }
        builder.addNode("connection-factory", name);
        ModelNode entriesNode = builder.getModelNode().get("entries");
        if (entriesStr == null) {
            entriesNode.add(name);
        } else {
            String[] split = entriesStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                String entry = split[i].trim();
                if (entry.isEmpty()) continue;
                entriesNode.add(entry);
            }
        }
        return builder.buildRequest();
    }
}

