/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.SimpleTabCompleterWithDelegate;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultOperationCallbackHandler;

public class PrefixHandler
extends CommandHandlerWithHelp {
    public PrefixHandler() {
        this("cn");
    }

    public PrefixHandler(String command) {
        super(command, true, new SimpleTabCompleterWithDelegate(new String[]{"--help"}, OperationRequestCompleter.INSTANCE));
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        OperationRequestAddress prefix = ctx.getPrefix();
        if (!ctx.hasArguments()) {
            ctx.printLine(ctx.getPrefixFormatter().format(prefix));
            return;
        }
        DefaultOperationCallbackHandler handler = new DefaultOperationCallbackHandler(ctx.getPrefix());
        try {
            ctx.getOperationRequestParser().parse(ctx.getCommandArguments(), handler);
        }
        catch (CommandFormatException e) {
            ctx.printLine(e.getLocalizedMessage());
        }
    }
}

