/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.dmr.ModelNode;

public class BatchRunHandler
extends CommandHandlerWithHelp {
    public BatchRunHandler() {
        super("batch-run");
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            ctx.printLine("No active batch.");
            return;
        }
        Batch batch = batchManager.getActiveBatch();
        List<BatchedCommand> currentBatch = batch.getCommands();
        if (currentBatch.isEmpty()) {
            ctx.printLine("The batch is empty.");
            batchManager.discardActiveBatch();
            return;
        }
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        ModelNode steps = composite.get("steps");
        for (BatchedCommand cmd : currentBatch) {
            steps.add(cmd.getRequest());
        }
        try {
            ModelNode result = ctx.getModelControllerClient().execute(composite);
            if (Util.isSuccess(result)) {
                batchManager.discardActiveBatch();
                ctx.printLine("The batch executed successfully.");
            } else {
                ctx.printLine("Failed to execute batch: " + Util.getFailureDescription(result));
            }
        }
        catch (Exception e) {
            ctx.printLine("Failed to execute batch: " + e.getLocalizedMessage());
        }
    }
}

