/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jms;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class JmsQueueRemoveHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public List<String> getAllCandidates(CommandContext ctx) {
            return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
        }
    }), "--profile"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };
    private final ArgumentWithValue name = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        @Override
        public List<String> getAllCandidates(CommandContext ctx) {
            String profileArg;
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                return Collections.emptyList();
            }
            if (!ctx.isDomainMode()) {
                profileArg = null;
            } else {
                profileArg = JmsQueueRemoveHandler.this.profile.getValue(ctx.getParsedArguments());
                if (profileArg == null) {
                    return Collections.emptyList();
                }
            }
            return Util.getJmsResources(ctx.getModelControllerClient(), profileArg, "queue");
        }
    }), 0, "--name"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (ctx.isDomainMode() && !JmsQueueRemoveHandler.this.profile.isPresent(ctx.getParsedArguments())) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };

    public JmsQueueRemoveHandler() {
        super("jms-queue-remove", true);
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(ctx.getParsedArguments());
            if (profile == null) {
                throw new OperationFormatException("Required argument --profile is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(ctx.getParsedArguments(), true);
        builder.addNode("subsystem", "messaging");
        builder.addNode("jms-queue", name);
        builder.setOperationName("remove");
        return builder.buildRequest();
    }
}

