/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.ParsedArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.impl.RequestParamArgWithValue;
import org.jboss.dmr.ModelNode;

public class RequestParamPropertiesArg
extends RequestParamArgWithValue {
    public RequestParamPropertiesArg(String paramName, CommandHandlerWithArguments handler, CommandLineCompleter valueCompleter) {
        super(paramName, handler, valueCompleter);
    }

    public RequestParamPropertiesArg(String paramName, CommandHandlerWithArguments handler, String fullArgName) {
        super(paramName, handler, fullArgName);
    }

    public RequestParamPropertiesArg(String paramName, CommandHandlerWithArguments handler) {
        super(paramName, handler);
    }

    @Override
    public void set(ParsedArguments args, ModelNode request) throws CommandFormatException {
        String value = this.getValue(args);
        if (value != null) {
            RequestParamPropertiesArg.setPropertyMapValue(request, this.paramName, value);
        }
    }

    protected static void setPropertyMapValue(ModelNode request, String name, String value) throws CommandFormatException {
        String[] props;
        if (name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument name is not specified: '" + name + "'");
        }
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("The argument value is not specified: '" + value + "'");
        }
        ModelNode nodeValue = new ModelNode();
        for (String prop : props = value.split(",")) {
            int equals = prop.indexOf(61);
            if (equals == -1) {
                throw new CommandFormatException("Property '" + prop + "' in '" + value + "' is missing the equals sign.");
            }
            String propName = prop.substring(0, equals);
            if (propName.isEmpty()) {
                throw new CommandFormatException("Property name is missing for '" + prop + "' in '" + value + "'");
            }
            nodeValue.add(propName, prop.substring(equals + 1));
        }
        request.get(name).set(nodeValue);
    }
}

