/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.Collections;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

public class DefaultOperationCandidatesProvider
implements OperationCandidatesProvider {
    private final CommandContext ctx;

    public DefaultOperationCandidatesProvider(CommandContext ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("The context can't be null!");
        }
        this.ctx = ctx;
    }

    @Override
    public List<String> getNodeNames(OperationRequestAddress prefix) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("The prefix must end on a type but it's empty.");
        }
        if (!prefix.endsOnType()) {
            throw new IllegalArgumentException("The prefix doesn't end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(prefix);
        try {
            builder.operationName("read-children-names");
            builder.property("child-type", prefix.getNodeType(), -1);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<String> getNodeTypes(OperationRequestAddress prefix) {
        return Util.getNodeTypes(this.ctx.getModelControllerClient(), prefix);
    }

    @Override
    public List<String> getOperationNames(OperationRequestAddress prefix) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (prefix.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(prefix);
        try {
            builder.operationName("read-operation-names");
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    @Override
    public List<String> getPropertyNames(String operationName, OperationRequestAddress address) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = this.ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (address.endsOnType()) {
            throw new IllegalArgumentException("The prefix isn't expected to end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
        try {
            builder.operationName("read-operation-description");
            builder.property("name", operationName, -1);
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            if (!Util.isSuccess(outcome)) {
                result = Collections.emptyList();
            } else {
                outcome.get("request-properties");
                result = Util.getRequestPropertyNames(outcome);
            }
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }
}

