/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.io.File;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.FilenameTabCompleter;

public class WindowsFilenameTabCompleter
extends FilenameTabCompleter {
    public static final WindowsFilenameTabCompleter INSTANCE = new WindowsFilenameTabCompleter();

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        int lastSeparator;
        int lastQuote;
        boolean openQuote = false;
        boolean dontCloseQuote = false;
        if (buffer.length() >= 2 && buffer.charAt(0) == '\"' && (lastQuote = buffer.lastIndexOf(34)) >= 0) {
            StringBuilder buf = new StringBuilder();
            buf.append(buffer.substring(1, lastQuote));
            if (lastQuote != buffer.length() - 1) {
                buf.append(buffer.substring(lastQuote + 1));
            }
            buffer = buf.toString();
            openQuote = true;
            dontCloseQuote = cursor <= lastQuote;
        }
        int result = this.getCandidates(buffer, candidates);
        String path = buffer.length() == 0 ? null : ((lastSeparator = buffer.lastIndexOf(File.separatorChar)) > 0 ? buffer.substring(0, lastSeparator + 1) : null);
        if (path != null && !openQuote) {
            boolean bl = openQuote = path.indexOf(32) >= 0;
        }
        if (candidates.size() == 1) {
            String candidate = candidates.get(0);
            if (!openQuote) {
                boolean bl = openQuote = candidate.indexOf(32) >= 0;
            }
            if (openQuote) {
                StringBuilder buf = new StringBuilder();
                buf.append('\"');
                if (path != null) {
                    buf.append(path);
                }
                buf.append(candidate);
                if (!dontCloseQuote) {
                    buf.append('\"');
                }
                candidates.set(0, buf.toString());
            }
        } else {
            String common = Util.getCommonStart(candidates);
            if (!openQuote && common != null) {
                boolean bl = openQuote = common.indexOf(32) >= 0;
            }
            if (openQuote) {
                for (int i = 0; i < candidates.size(); ++i) {
                    StringBuilder buf = new StringBuilder();
                    buf.append('\"');
                    if (path != null) {
                        buf.append(path);
                    }
                    if (common == null) {
                        if (!dontCloseQuote) {
                            buf.append('\"');
                        }
                        buf.append(candidates.get(i));
                    } else {
                        buf.append(common);
                        if (!dontCloseQuote) {
                            buf.append('\"');
                        }
                        buf.append(candidates.get(i).substring(common.length()));
                    }
                    candidates.set(i, buf.toString());
                }
            }
        }
        if (openQuote) {
            return 0;
        }
        return result;
    }

    @Override
    protected boolean startsWithRoot(String path) {
        return path.contains(":\\");
    }
}

