/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestParser;
import org.jboss.as.cli.operation.parsing.OperationRequestState;
import org.jboss.as.cli.operation.parsing.ParsingContext;
import org.jboss.as.cli.operation.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.operation.parsing.StateParser;

public class DefaultOperationRequestParser
implements OperationRequestParser {
    public static final OperationRequestParser INSTANCE = new DefaultOperationRequestParser();
    public static final String FORMAT = "[node-type=node-name (, node-type=node-name)*] : operation-name [ '(' name=value (, name=value)* ')' ]";
    public static final char NODE_TYPE_NAME_SEPARATOR = '=';
    public static final char NODE_SEPARATOR = '/';
    public static final char ADDRESS_OPERATION_NAME_SEPARATOR = ':';
    public static final char ARGUMENTS_LIST_START = '(';
    public static final char ARGUMENT_NAME_VALUE_SEPARATOR = '=';
    public static final char ARGUMENT_SEPARATOR = ',';
    public static final char ARGUMENTS_LIST_END = ')';
    public static final String ROOT_NODE = "/";
    public static final String PARENT_NODE = "..";
    public static final String NODE_TYPE = ".type";

    @Override
    public void parse(String operationRequest, final OperationRequestParser.CallbackHandler handler) throws OperationFormatException {
        if (operationRequest == null || operationRequest.isEmpty()) {
            return;
        }
        ParsingStateCallbackHandler stateCallbackHandler = new ParsingStateCallbackHandler(){
            StringBuilder buffer = new StringBuilder();
            int propNameValueSep = -1;
            StringBuilder propName;
            boolean propValueContent;

            @Override
            public void enteredState(ParsingContext ctx) throws OperationFormatException {
                String stateId = ctx.getState().getId();
                if (stateId.equals("OP")) {
                    handler.addressOperationSeparator(ctx.getLocation());
                } else if (stateId.equals("PROP_LIST")) {
                    handler.propertyListStart(ctx.getLocation());
                } else if (stateId.equals("PARAM")) {
                    this.propName = new StringBuilder();
                } else if (stateId.equals("PROP_VALUE")) {
                    this.propNameValueSep = ctx.getLocation();
                    this.propValueContent = true;
                    this.buffer.setLength(0);
                } else if (stateId.equals("NODE")) {
                    this.propValueContent = true;
                    this.buffer.setLength(0);
                }
                if (!this.propValueContent) {
                    this.buffer.setLength(0);
                }
            }

            @Override
            public void leavingState(ParsingContext ctx) throws OperationFormatException {
                String stateId = ctx.getState().getId();
                if (stateId.equals("PROP_LIST")) {
                    if (ctx.getCharacter() == ')') {
                        handler.propertyListEnd(ctx.getLocation());
                    }
                } else if (stateId.equals("PARAM")) {
                    if (this.buffer.length() > 0) {
                        handler.property(this.propName.toString().trim(), this.buffer.toString().trim(), this.propNameValueSep);
                    } else {
                        handler.propertyName(this.propName.toString().trim());
                        if (this.propNameValueSep != -1) {
                            handler.propertyNameValueSeparator(this.propNameValueSep);
                        }
                    }
                    if (ctx.getCharacter() == ',') {
                        handler.propertySeparator(ctx.getLocation());
                    }
                    this.propName = null;
                    this.propNameValueSep = -1;
                    this.propValueContent = false;
                } else if (stateId.equals("OP_NAME")) {
                    handler.operationName(this.buffer.toString().trim());
                } else if (stateId.equals("NODE")) {
                    char ch = ctx.getCharacter();
                    if (this.buffer.length() == 0) {
                        if (ch == '/') {
                            handler.rootNode();
                            handler.nodeSeparator(ctx.getLocation());
                        }
                    } else if (ch == '=') {
                        handler.nodeType(this.buffer.toString().trim());
                        handler.nodeTypeNameSeparator(ctx.getLocation());
                    } else if (ch == ':') {
                        handler.nodeName(this.buffer.toString().trim());
                    } else {
                        String value = this.buffer.toString().trim();
                        if (!".".equals(value)) {
                            if (DefaultOperationRequestParser.PARENT_NODE.equals(value)) {
                                handler.parentNode();
                            } else if (DefaultOperationRequestParser.NODE_TYPE.equals(value)) {
                                handler.nodeType();
                            } else if (ch == '/') {
                                if ("".equals(value)) {
                                    handler.rootNode();
                                } else {
                                    handler.nodeName(value);
                                }
                            } else {
                                handler.nodeTypeOrName(value);
                            }
                        }
                        if (ch == '/') {
                            handler.nodeSeparator(ctx.getLocation());
                        }
                    }
                    this.propValueContent = false;
                }
            }

            @Override
            public void character(ParsingContext ctx) throws OperationFormatException {
                String stateId = ctx.getState().getId();
                if (stateId.equals("PARAM")) {
                    this.propName.append(ctx.getCharacter());
                } else {
                    this.buffer.append(ctx.getCharacter());
                }
            }
        };
        try {
            StateParser.parse(operationRequest, stateCallbackHandler, OperationRequestState.INSTANCE);
        }
        catch (CommandFormatException e) {
            throw new OperationFormatException("Failed to parse operation request '" + operationRequest + "'", e);
        }
    }
}

