/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.util.Collections;
import java.util.List;
import jline.Completor;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.impl.CommandCandidatesProvider;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationRequestCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;

public class CommandCompleter
implements Completor,
CommandLineCompleter {
    private final CommandContext ctx;
    private final CommandRegistry cmdRegistry;
    private final CommandCandidatesProvider cmdProvider;

    public CommandCompleter(CommandRegistry cmdRegistry, CommandContext ctx) {
        if (cmdRegistry == null) {
            throw new IllegalArgumentException("Command registry can't be null.");
        }
        this.cmdRegistry = cmdRegistry;
        this.cmdProvider = new CommandCandidatesProvider(cmdRegistry);
        this.ctx = ctx;
    }

    public int complete(String buffer, int cursor, List candidates) {
        return this.complete(this.ctx, buffer, cursor, candidates);
    }

    @Override
    public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
        OperationCandidatesProvider candidatesProvider;
        DefaultCallbackHandler parsedCmd;
        block7: {
            if (buffer.isEmpty()) {
                for (String cmd : this.cmdRegistry.getTabCompletionCommands()) {
                    CommandHandler handler = this.cmdRegistry.getCommandHandler(cmd);
                    if (!handler.isAvailable(ctx)) continue;
                    candidates.add(cmd);
                }
                Collections.sort(candidates);
                return 0;
            }
            parsedCmd = (DefaultCallbackHandler)ctx.getParsedCommandLine();
            try {
                parsedCmd.parse(ctx.getPrefix(), buffer);
            }
            catch (CommandFormatException e) {
                if (parsedCmd.endsOnAddressOperationNameSeparator() && parsedCmd.endsOnSeparator()) break block7;
                return -1;
            }
        }
        if (buffer.isEmpty()) {
            candidatesProvider = this.cmdProvider;
        } else {
            int cmdFirstIndex;
            for (cmdFirstIndex = 0; cmdFirstIndex < buffer.length() && Character.isWhitespace(buffer.charAt(cmdFirstIndex)); ++cmdFirstIndex) {
            }
            char firstChar = buffer.charAt(cmdFirstIndex);
            candidatesProvider = firstChar == '.' || firstChar == ':' || firstChar == '/' ? ctx.getOperationCandidatesProvider() : this.cmdProvider;
        }
        return OperationRequestCompleter.INSTANCE.complete(ctx, parsedCmd, candidatesProvider, buffer, cursor, candidates);
    }
}

