/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.batch;

import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class BatchHoldbackHandler
extends CommandHandlerWithHelp {
    public BatchHoldbackHandler() {
        super("batch-holdback");
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        if (!super.isAvailable(ctx)) {
            return false;
        }
        return ctx.isBatchMode();
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandFormatException {
        BatchManager batchManager = ctx.getBatchManager();
        if (!batchManager.isBatchActive()) {
            ctx.printLine("No active batch to holdback.");
            return;
        }
        String name = null;
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (args.hasProperties()) {
            name = args.getOtherProperties().get(0);
        }
        if (batchManager.isHeldback(name)) {
            ctx.printLine("There already is " + (name == null ? "unnamed" : "'" + name + "'") + " batch held back.");
            return;
        }
        if (!batchManager.holdbackActiveBatch(name)) {
            ctx.printLine("Failed to holdback the batch.");
        }
    }
}

