/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.Security;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.RealmChoiceCallback;
import javax.security.sasl.SaslException;
import jline.Completor;
import jline.ConsoleReader;
import org.jboss.as.cli.CommandCompleter;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandHandler;
import org.jboss.as.cli.CommandHistory;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.CommandRegistry;
import org.jboss.as.cli.OperationCommand;
import org.jboss.as.cli.SecurityActions;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.batch.BatchedCommand;
import org.jboss.as.cli.batch.impl.DefaultBatchManager;
import org.jboss.as.cli.batch.impl.DefaultBatchedCommand;
import org.jboss.as.cli.handlers.ClearScreenHandler;
import org.jboss.as.cli.handlers.CommandCommandHandler;
import org.jboss.as.cli.handlers.ConnectHandler;
import org.jboss.as.cli.handlers.DeployHandler;
import org.jboss.as.cli.handlers.GenericTypeOperationHandler;
import org.jboss.as.cli.handlers.HelpHandler;
import org.jboss.as.cli.handlers.HistoryHandler;
import org.jboss.as.cli.handlers.LsHandler;
import org.jboss.as.cli.handlers.OperationRequestHandler;
import org.jboss.as.cli.handlers.PrefixHandler;
import org.jboss.as.cli.handlers.PrintWorkingNodeHandler;
import org.jboss.as.cli.handlers.QuitHandler;
import org.jboss.as.cli.handlers.UndeployHandler;
import org.jboss.as.cli.handlers.VersionHandler;
import org.jboss.as.cli.handlers.batch.BatchClearHandler;
import org.jboss.as.cli.handlers.batch.BatchDiscardHandler;
import org.jboss.as.cli.handlers.batch.BatchEditLineHandler;
import org.jboss.as.cli.handlers.batch.BatchHandler;
import org.jboss.as.cli.handlers.batch.BatchHoldbackHandler;
import org.jboss.as.cli.handlers.batch.BatchListHandler;
import org.jboss.as.cli.handlers.batch.BatchMoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRemoveLineHandler;
import org.jboss.as.cli.handlers.batch.BatchRunHandler;
import org.jboss.as.cli.handlers.jca.DataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.DataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.DataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceAddHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceModifyHandler;
import org.jboss.as.cli.handlers.jca.XADataSourceRemoveHandler;
import org.jboss.as.cli.handlers.jms.CreateJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.DeleteJmsResourceHandler;
import org.jboss.as.cli.handlers.jms.JmsCFAddHandler;
import org.jboss.as.cli.handlers.jms.JmsCFRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueAddHandler;
import org.jboss.as.cli.handlers.jms.JmsQueueRemoveHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicAddHandler;
import org.jboss.as.cli.handlers.jms.JmsTopicRemoveHandler;
import org.jboss.as.cli.operation.CommandLineParser;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.PrefixFormatter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationCandidatesProvider;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestAddress;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestParser;
import org.jboss.as.cli.operation.impl.DefaultPrefixFormatter;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.sasl.JBossSaslProvider;
import org.jboss.sasl.callback.DigestHashCallback;

public class CommandLineMain {
    private static final CommandRegistry cmdRegistry = new CommandRegistry();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    return Security.insertProviderAt((Provider)new JBossSaslProvider(), 1);
                }
            });
            String argError = null;
            String[] commands = null;
            File file = null;
            boolean connect = false;
            String defaultControllerHost = null;
            int defaultControllerPort = -1;
            boolean version = false;
            String username = null;
            char[] password = null;
            for (String arg : args) {
                String value;
                if (arg.startsWith("--controller=") || arg.startsWith("controller=")) {
                    value = arg.startsWith("--") ? arg.substring(13) : arg.substring(11);
                    String portStr = null;
                    int colonIndex = value.indexOf(58);
                    if (colonIndex < 0) {
                        defaultControllerHost = value;
                    } else if (colonIndex == 0) {
                        portStr = value.substring(1);
                    } else {
                        defaultControllerHost = value.substring(0, colonIndex);
                        portStr = value.substring(colonIndex + 1);
                    }
                    if (portStr == null) continue;
                    int port = -1;
                    try {
                        port = Integer.parseInt(portStr);
                        if (port < 0) {
                            argError = "The port must be a valid non-negative integer: '" + args + "'";
                            continue;
                        }
                        defaultControllerPort = port;
                    }
                    catch (NumberFormatException e) {
                        argError = "The port must be a valid non-negative integer: '" + arg + "'";
                    }
                    continue;
                }
                if ("--connect".equals(arg) || "-c".equals(arg)) {
                    connect = true;
                    continue;
                }
                if ("--version".equals(arg)) {
                    version = true;
                    continue;
                }
                if (arg.startsWith("--file=") || arg.startsWith("file=")) {
                    String fileName;
                    if (file != null) {
                        argError = "Duplicate argument '--file'.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    String string = fileName = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    if (!fileName.isEmpty()) {
                        file = new File(fileName);
                        if (file.exists()) continue;
                        argError = "File " + file.getAbsolutePath() + " doesn't exist.";
                        break;
                    }
                    argError = "Argument '--file' is missing value.";
                    break;
                }
                if (arg.startsWith("--commands=") || arg.startsWith("commands=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(11) : arg.substring(9);
                    commands = value.split(",+");
                    continue;
                }
                if (arg.startsWith("--command=") || arg.startsWith("command=")) {
                    if (file != null) {
                        argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                        break;
                    }
                    if (commands != null) {
                        argError = "Duplicate argument '--command'/'--commands'.";
                        break;
                    }
                    value = arg.startsWith("--") ? arg.substring(10) : arg.substring(8);
                    commands = new String[]{value};
                    continue;
                }
                if (arg.startsWith("--user=")) {
                    username = arg.startsWith("--") ? arg.substring(7) : arg.substring(5);
                    continue;
                }
                if (arg.startsWith("--password=")) {
                    password = (arg.startsWith("--") ? arg.substring(11) : arg.substring(9)).toCharArray();
                    continue;
                }
                if (arg.equals("--help") || arg.equals("-h")) {
                    commands = new String[]{"help"};
                    continue;
                }
                if (file != null) {
                    argError = "Only one of '--file', '--commands' or '--command' can appear as the argument at a time.";
                    break;
                }
                if (commands != null) {
                    argError = "Duplicate argument '--command'/'--commands'.";
                    break;
                }
                commands = arg.split(",+");
            }
            if (argError != null) {
                System.err.println(argError);
                return;
            }
            if (version) {
                CommandContextImpl cmdCtx = new CommandContextImpl();
                VersionHandler.INSTANCE.handle(cmdCtx);
                return;
            }
            if (file != null) {
                CommandLineMain.processFile(file, defaultControllerHost, defaultControllerPort, connect, username, password);
                return;
            }
            if (commands != null) {
                CommandLineMain.processCommands(commands, defaultControllerHost, defaultControllerPort, connect, username, password);
                return;
            }
            ConsoleReader console = CommandLineMain.initConsoleReader();
            final CommandContextImpl cmdCtx = new CommandContextImpl(console);
            SecurityActions.addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    cmdCtx.disconnectController();
                }
            }));
            console.addCompletor((Completor)cmdCtx.cmdCompleter);
            cmdCtx.username = username;
            CommandContextImpl.access$402(cmdCtx, password);
            if (defaultControllerHost != null) {
                cmdCtx.defaultControllerHost = defaultControllerHost;
            }
            if (defaultControllerPort != -1) {
                cmdCtx.defaultControllerPort = defaultControllerPort;
            }
            if (connect) {
                cmdCtx.connectController(null, -1);
            } else {
                cmdCtx.printLine("You are disconnected at the moment. Type 'connect' to connect to the server or 'help' for the list of supported commands.");
            }
            try {
                while (!cmdCtx.terminate) {
                    String line = console.readLine(cmdCtx.getPrompt());
                    if (line == null) {
                        cmdCtx.terminateSession();
                        continue;
                    }
                    CommandLineMain.processLine(cmdCtx, line.trim());
                }
                cmdCtx.disconnectController();
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    cmdCtx.disconnectController();
                }
            }
        }
        finally {
            System.exit(0);
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(String[] commands, String defaultControllerHost, int defaultControllerPort, boolean connect, String username, char[] password) {
        final CommandContextImpl cmdCtx = new CommandContextImpl();
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        cmdCtx.username = username;
        CommandContextImpl.access$402(cmdCtx, password);
        if (defaultControllerHost != null) {
            cmdCtx.defaultControllerHost = defaultControllerHost;
        }
        if (defaultControllerPort != -1) {
            cmdCtx.defaultControllerPort = defaultControllerPort;
        }
        if (connect) {
            cmdCtx.connectController(null, -1);
        }
        try {
            for (int i = 0; i < commands.length && !cmdCtx.terminate; ++i) {
                CommandLineMain.processLine(cmdCtx, commands[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (!cmdCtx.terminate) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processFile(File file, String defaultControllerHost, int defaultControllerPort, boolean connect, String username, char[] password) {
        final CommandContextImpl cmdCtx = new CommandContextImpl();
        SecurityActions.addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                cmdCtx.disconnectController();
            }
        }));
        cmdCtx.username = username;
        CommandContextImpl.access$402(cmdCtx, password);
        if (defaultControllerHost != null) {
            cmdCtx.defaultControllerHost = defaultControllerHost;
        }
        if (defaultControllerPort != -1) {
            cmdCtx.defaultControllerPort = defaultControllerPort;
        }
        if (connect) {
            cmdCtx.connectController(null, -1);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (!cmdCtx.terminate && line != null) {
                CommandLineMain.processLine(cmdCtx, line.trim());
                line = reader.readLine();
            }
        }
        catch (Throwable e) {
            try {
                cmdCtx.printLine("Failed to process file '" + file.getAbsolutePath() + "'");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                StreamUtils.safeClose(reader);
                if (!cmdCtx.terminate) {
                    cmdCtx.terminateSession();
                }
                cmdCtx.disconnectController();
                throw throwable;
            }
            StreamUtils.safeClose((Closeable)reader);
            if (!cmdCtx.terminate) {
                cmdCtx.terminateSession();
            }
            cmdCtx.disconnectController();
        }
        StreamUtils.safeClose((Closeable)reader);
        if (!cmdCtx.terminate) {
            cmdCtx.terminateSession();
        }
        cmdCtx.disconnectController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void processLine(CommandContextImpl cmdCtx, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (line.charAt(0) == '#') {
            return;
        }
        if (CommandLineMain.isOperation(line)) {
            ModelNode request;
            try {
                cmdCtx.resetArgs(line);
                request = cmdCtx.parsedCmd.toOperationRequest();
            }
            catch (CommandFormatException e) {
                cmdCtx.printLine(e.getLocalizedMessage());
                return;
            }
            if (cmdCtx.isBatchMode()) {
                StringBuilder op = new StringBuilder();
                op.append(cmdCtx.getPrefixFormatter().format(cmdCtx.parsedCmd.getAddress()));
                op.append(line.substring(line.indexOf(58)));
                DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(op.toString(), request);
                Batch batch = cmdCtx.getBatchManager().getActiveBatch();
                batch.add(batchedCmd);
                cmdCtx.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
            } else {
                cmdCtx.set("OP_REQ", request);
                try {
                    cmdCtx.operationHandler.handle(cmdCtx);
                }
                finally {
                    cmdCtx.set("OP_REQ", null);
                }
            }
        } else {
            try {
                cmdCtx.resetArgs(line);
            }
            catch (CommandFormatException e1) {
                cmdCtx.printLine(e1.getLocalizedMessage());
                return;
            }
            String cmdName = cmdCtx.parsedCmd.getOperationName();
            CommandHandler handler = cmdRegistry.getCommandHandler(cmdName.toLowerCase());
            if (handler != null) {
                if (cmdCtx.isBatchMode() && handler.isBatchMode()) {
                    if (!(handler instanceof OperationCommand)) {
                        cmdCtx.printLine("The command is not allowed in a batch.");
                    } else {
                        try {
                            ModelNode request = ((OperationCommand)handler).buildRequest(cmdCtx);
                            DefaultBatchedCommand batchedCmd = new DefaultBatchedCommand(line, request);
                            Batch batch = cmdCtx.getBatchManager().getActiveBatch();
                            batch.add(batchedCmd);
                            cmdCtx.printLine("#" + batch.size() + " " + batchedCmd.getCommand());
                        }
                        catch (CommandFormatException e) {
                            cmdCtx.printLine("Failed to add to batch: " + e.getLocalizedMessage());
                        }
                    }
                } else {
                    try {
                        handler.handle(cmdCtx);
                    }
                    catch (CommandFormatException e) {
                        cmdCtx.printLine(e.getLocalizedMessage());
                    }
                }
                try {
                    cmdCtx.resetArgs(null);
                }
                catch (CommandFormatException e) {}
            } else {
                cmdCtx.printLine("Unexpected command '" + line + "'. Type 'help' for the list of supported commands.");
            }
        }
    }

    protected static ConsoleReader initConsoleReader() {
        String osName = SecurityActions.getSystemProperty("os.name").toLowerCase();
        String bindingsName = osName.indexOf("windows") >= 0 ? "keybindings/jline-windows-bindings.properties" : (osName.startsWith("mac") ? "keybindings/jline-mac-bindings.properties" : "keybindings/jline-default-bindings.properties");
        ClassLoader cl = SecurityActions.getClassLoader(CommandLineMain.class);
        InputStream bindingsIs = cl.getResourceAsStream(bindingsName);
        if (bindingsIs == null) {
            System.err.println("Failed to locate key bindings for OS '" + osName + "': " + bindingsName);
            try {
                return new ConsoleReader();
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to initialize console reader", e);
            }
        }
        try {
            FileInputStream in = new FileInputStream(FileDescriptor.in);
            String encoding = SecurityActions.getSystemProperty("jline.WindowsTerminal.output.encoding");
            if (encoding == null) {
                encoding = SecurityActions.getSystemProperty("file.encoding");
            }
            PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, encoding));
            ConsoleReader consoleReader = new ConsoleReader((InputStream)in, (Writer)out, bindingsIs);
            return consoleReader;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to initialize console reader", e);
        }
        finally {
            StreamUtils.safeClose((Closeable)bindingsIs);
        }
    }

    private static boolean isOperation(String line) {
        char firstChar = line.charAt(0);
        return firstChar == '.' || firstChar == ':' || firstChar == '/' || line.startsWith("..") || line.startsWith(".type");
    }

    static {
        cmdRegistry.registerHandler((CommandHandler)new HelpHandler(), "help", "h");
        cmdRegistry.registerHandler((CommandHandler)new QuitHandler(), "quit", "q", "exit");
        cmdRegistry.registerHandler((CommandHandler)new ConnectHandler(), "connect");
        cmdRegistry.registerHandler((CommandHandler)new PrefixHandler(), "cd", "cn");
        cmdRegistry.registerHandler((CommandHandler)new ClearScreenHandler(), "clear", "cls");
        cmdRegistry.registerHandler((CommandHandler)new LsHandler(), "ls");
        cmdRegistry.registerHandler((CommandHandler)new HistoryHandler(), "history");
        cmdRegistry.registerHandler((CommandHandler)new DeployHandler(), "deploy");
        cmdRegistry.registerHandler((CommandHandler)new UndeployHandler(), "undeploy");
        cmdRegistry.registerHandler((CommandHandler)new PrintWorkingNodeHandler(), "pwd", "pwn");
        cmdRegistry.registerHandler((CommandHandler)new BatchHandler(), "batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchDiscardHandler(), "discard-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchListHandler(), "list-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchHoldbackHandler(), "holdback-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRunHandler(), "run-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchClearHandler(), "clear-batch");
        cmdRegistry.registerHandler((CommandHandler)new BatchRemoveLineHandler(), "remove-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchMoveLineHandler(), "move-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new BatchEditLineHandler(), "edit-batch-line");
        cmdRegistry.registerHandler((CommandHandler)new VersionHandler(), "version");
        cmdRegistry.registerHandler((CommandHandler)new CommandCommandHandler(cmdRegistry), "command");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=datasources/data-source", "jndi-name"), "data-source");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=datasources/xa-data-source", "jndi-name"), "xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceAddHandler(), false, "add-data-source");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceModifyHandler(), false, "modify-data-source");
        cmdRegistry.registerHandler((CommandHandler)new DataSourceRemoveHandler(), false, "remove-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceAddHandler(), false, "add-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceRemoveHandler(), false, "remove-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new XADataSourceModifyHandler(), false, "modify-xa-data-source");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=messaging/hornetq-server=default/jms-queue", "queue-address"), "jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=messaging/hornetq-server=default/jms-topic", "topic-address"), "jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new GenericTypeOperationHandler("/subsystem=messaging/hornetq-server=default/connection-factory", null), "connection-factory");
        cmdRegistry.registerHandler((CommandHandler)new JmsQueueAddHandler(), false, "add-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new JmsQueueRemoveHandler(), false, "remove-jms-queue");
        cmdRegistry.registerHandler((CommandHandler)new JmsTopicAddHandler(), false, "add-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new JmsTopicRemoveHandler(), false, "remove-jms-topic");
        cmdRegistry.registerHandler((CommandHandler)new JmsCFAddHandler(), false, "add-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new JmsCFRemoveHandler(), false, "remove-jms-cf");
        cmdRegistry.registerHandler((CommandHandler)new CreateJmsResourceHandler(), false, "create-jms-resource");
        cmdRegistry.registerHandler((CommandHandler)new DeleteJmsResourceHandler(), false, "delete-jms-resource");
    }

    static class CommandContextImpl
    implements CommandContext {
        private ConsoleReader console;
        private final CommandHistory history;
        private boolean terminate;
        private String cmdLine;
        private DefaultCallbackHandler parsedCmd = new DefaultCallbackHandler(true);
        private boolean domainMode;
        private ModelControllerClient client;
        private String defaultControllerHost = "localhost";
        private int defaultControllerPort = 9999;
        private String controllerHost;
        private int controllerPort = -1;
        private String username;
        private char[] password;
        private Map<String, Object> map = new HashMap<String, Object>();
        private final OperationRequestAddress prefix = new DefaultOperationRequestAddress();
        private final PrefixFormatter prefixFormatter = new DefaultPrefixFormatter();
        private final OperationCandidatesProvider operationCandidatesProvider;
        private final OperationRequestHandler operationHandler;
        private BatchManager batchManager = new DefaultBatchManager();
        private final CommandCompleter cmdCompleter;
        private BufferedWriter outputTarget;
        String promptConnectPart;
        private final DefaultCallbackHandler tmpBatched = new DefaultCallbackHandler();

        private CommandContextImpl() {
            this.console = null;
            this.history = null;
            this.operationCandidatesProvider = null;
            this.cmdCompleter = null;
            this.operationHandler = new OperationRequestHandler();
        }

        private CommandContextImpl(ConsoleReader console) {
            this.console = console;
            console.setUseHistory(true);
            String userHome = SecurityActions.getSystemProperty("user.home");
            File historyFile = new File(userHome, ".jboss-cli-history");
            try {
                console.getHistory().setHistoryFile(historyFile);
            }
            catch (IOException e) {
                System.err.println("Failed to setup the history file " + historyFile.getAbsolutePath() + ": " + e.getLocalizedMessage());
            }
            this.history = new HistoryImpl();
            this.operationCandidatesProvider = new DefaultOperationCandidatesProvider();
            this.operationHandler = new OperationRequestHandler();
            this.cmdCompleter = new CommandCompleter(cmdRegistry, this);
        }

        @Override
        public String getArgumentsString() {
            if (this.cmdLine != null && this.parsedCmd.getOperationName() != null) {
                int cmdNameLength = this.parsedCmd.getOperationName().length();
                if (this.cmdLine.length() == cmdNameLength) {
                    return null;
                }
                return this.cmdLine.substring(cmdNameLength + 1);
            }
            return null;
        }

        @Override
        public void terminateSession() {
            this.terminate = true;
        }

        @Override
        public void printLine(String message) {
            if (this.outputTarget != null) {
                try {
                    this.outputTarget.append(message);
                    this.outputTarget.newLine();
                    this.outputTarget.flush();
                }
                catch (IOException e) {
                    System.err.println("Failed to print '" + message + "' to the output target: " + e.getLocalizedMessage());
                }
                return;
            }
            if (this.console != null) {
                try {
                    this.console.printString(message);
                    this.console.printNewline();
                }
                catch (IOException e) {
                    System.err.println("Failed to print '" + message + "' to the console: " + e.getLocalizedMessage());
                }
            } else {
                System.out.println(message);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readLine(String prompt, boolean password, boolean disableHistory) throws IOException {
            boolean useHistory;
            if (this.console == null) {
                this.console = CommandLineMain.initConsoleReader();
            }
            if ((useHistory = this.console.getUseHistory()) && disableHistory) {
                this.console.setUseHistory(false);
            }
            try {
                if (password) {
                    String string = this.console.readLine(prompt, Character.valueOf('\u0000'));
                    return string;
                }
                String string = this.console.readLine(prompt);
                return string;
            }
            finally {
                if (disableHistory && useHistory) {
                    this.console.setUseHistory(true);
                }
            }
        }

        @Override
        public void printColumns(Collection<String> col) {
            if (this.outputTarget != null) {
                try {
                    for (String item : col) {
                        this.outputTarget.append(item);
                        this.outputTarget.newLine();
                    }
                }
                catch (IOException e) {
                    System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
                }
                return;
            }
            if (this.console != null) {
                try {
                    this.console.printColumns(col);
                }
                catch (IOException e) {
                    System.err.println("Failed to print columns '" + col + "' to the console: " + e.getLocalizedMessage());
                }
            } else {
                for (String item : col) {
                    System.out.println(item);
                }
            }
        }

        @Override
        public void set(String key, Object value) {
            this.map.put(key, value);
        }

        @Override
        public Object get(String key) {
            return this.map.get(key);
        }

        @Override
        public ModelControllerClient getModelControllerClient() {
            return this.client;
        }

        @Override
        public CommandLineParser getCommandLineParser() {
            return DefaultOperationRequestParser.INSTANCE;
        }

        @Override
        public OperationRequestAddress getPrefix() {
            return this.prefix;
        }

        @Override
        public PrefixFormatter getPrefixFormatter() {
            return this.prefixFormatter;
        }

        @Override
        public OperationCandidatesProvider getOperationCandidatesProvider() {
            return this.operationCandidatesProvider;
        }

        @Override
        public void connectController(String host, int port) {
            if (host == null) {
                host = this.defaultControllerHost;
            }
            if (port < 0) {
                port = this.defaultControllerPort;
            }
            try {
                ModelControllerClient newClient = null;
                AuthenticationCallbackHandler cbh = new AuthenticationCallbackHandler(this.username, this.password);
                ModelControllerClient tempClient = ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)cbh);
                switch (this.initialConnection(tempClient)) {
                    case SUCCESS: {
                        newClient = tempClient;
                        break;
                    }
                    case CONNECTION_FAILURE: {
                        this.printLine("The controller is not available at " + host + ":" + port);
                        break;
                    }
                    case AUTHENTICATION_FAILURE: {
                        this.printLine("Unable to authenticate against controller at " + host + ":" + port);
                    }
                }
                if (newClient != null) {
                    if (this.client != null) {
                        this.disconnectController();
                    }
                    this.client = newClient;
                    this.controllerHost = host;
                    this.controllerPort = port;
                    List<String> nodeTypes = Util.getNodeTypes(newClient, new DefaultOperationRequestAddress());
                    this.domainMode = nodeTypes.contains("server-group");
                }
            }
            catch (UnknownHostException e) {
                this.printLine("Failed to resolve host '" + host + "': " + e.getLocalizedMessage());
            }
        }

        private ConnectStatus initialConnection(ModelControllerClient client) {
            try {
                DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
                builder.setOperationName("read-attribute");
                builder.addProperty("name", "name");
                client.execute(builder.buildRequest());
                return ConnectStatus.SUCCESS;
            }
            catch (Exception e) {
                boolean authenticationFailure = false;
                for (Throwable current = e; current != null && !authenticationFailure; current = current.getCause()) {
                    if (!(current instanceof SaslException)) continue;
                    authenticationFailure = true;
                }
                StreamUtils.safeClose((Closeable)client);
                return authenticationFailure ? ConnectStatus.AUTHENTICATION_FAILURE : ConnectStatus.CONNECTION_FAILURE;
            }
        }

        @Override
        public void disconnectController() {
            if (this.client != null) {
                StreamUtils.safeClose((Closeable)this.client);
                this.client = null;
                this.controllerHost = null;
                this.controllerPort = -1;
                this.domainMode = false;
            }
            this.promptConnectPart = null;
        }

        @Override
        public String getControllerHost() {
            return this.controllerHost;
        }

        @Override
        public int getControllerPort() {
            return this.controllerPort;
        }

        @Override
        public void clearScreen() {
            try {
                this.console.setDefaultPrompt("");
                this.console.clearScreen();
            }
            catch (IOException e) {
                this.printLine(e.getLocalizedMessage());
            }
        }

        String getPrompt() {
            StringBuilder buffer = new StringBuilder();
            if (this.promptConnectPart == null) {
                buffer.append('[');
                if (this.controllerHost != null) {
                    if (this.domainMode) {
                        buffer.append("domain@");
                    } else {
                        buffer.append("standalone@");
                    }
                    buffer.append(this.controllerHost).append(':').append(this.controllerPort).append(' ');
                    this.promptConnectPart = buffer.toString();
                } else {
                    buffer.append("disconnected ");
                }
            } else {
                buffer.append(this.promptConnectPart);
            }
            if (this.prefix.isEmpty()) {
                buffer.append('/');
            } else {
                buffer.append(this.prefix.getNodeType());
                String nodeName = this.prefix.getNodeName();
                if (nodeName != null) {
                    buffer.append('=').append(nodeName);
                }
            }
            if (this.isBatchMode()) {
                buffer.append(" #");
            }
            buffer.append("] ");
            return buffer.toString();
        }

        @Override
        public CommandHistory getHistory() {
            return this.history;
        }

        @Override
        public String getDefaultControllerHost() {
            return this.defaultControllerHost;
        }

        @Override
        public int getDefaultControllerPort() {
            return this.defaultControllerPort;
        }

        private void resetArgs(String cmdLine) throws CommandFormatException {
            if (cmdLine != null) {
                this.parsedCmd.parse(this.prefix, cmdLine);
                this.setOutputTarget(this.parsedCmd.getOutputTarget());
            }
            this.cmdLine = cmdLine;
        }

        @Override
        public boolean isBatchMode() {
            return this.batchManager.isBatchActive();
        }

        @Override
        public BatchManager getBatchManager() {
            return this.batchManager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BatchedCommand toBatchedCommand(String line) throws CommandFormatException {
            if (line.isEmpty()) {
                throw new IllegalArgumentException("Null command line.");
            }
            DefaultCallbackHandler originalParsedArguments = this.parsedCmd;
            try {
                this.parsedCmd = this.tmpBatched;
                this.resetArgs(line);
            }
            catch (CommandFormatException e) {
                this.parsedCmd = originalParsedArguments;
                throw e;
            }
            if (CommandLineMain.isOperation(line)) {
                try {
                    ModelNode request = this.parsedCmd.toOperationRequest();
                    StringBuilder op = new StringBuilder();
                    op.append(this.prefixFormatter.format(this.parsedCmd.getAddress()));
                    op.append(line.substring(line.indexOf(58)));
                    DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(op.toString(), request);
                    return defaultBatchedCommand;
                }
                finally {
                    this.parsedCmd = originalParsedArguments;
                }
            }
            CommandHandler handler = cmdRegistry.getCommandHandler(this.parsedCmd.getOperationName());
            if (handler == null) {
                throw new OperationFormatException("No command handler for '" + this.parsedCmd.getOperationName() + "'.");
            }
            if (!(handler instanceof OperationCommand)) {
                throw new OperationFormatException("The command is not allowed in a batch.");
            }
            try {
                ModelNode request = ((OperationCommand)handler).buildRequest(this);
                DefaultBatchedCommand defaultBatchedCommand = new DefaultBatchedCommand(line, request);
                return defaultBatchedCommand;
            }
            finally {
                this.parsedCmd = originalParsedArguments;
            }
        }

        @Override
        public CommandLineCompleter getDefaultCommandCompleter() {
            return this.cmdCompleter;
        }

        @Override
        public ParsedCommandLine getParsedCommandLine() {
            return this.parsedCmd;
        }

        @Override
        public boolean isDomainMode() {
            return this.domainMode;
        }

        protected void setOutputTarget(String filePath) {
            FileWriter writer;
            if (filePath == null) {
                this.outputTarget = null;
                return;
            }
            try {
                writer = new FileWriter(filePath, false);
            }
            catch (IOException e) {
                this.printLine(e.getLocalizedMessage());
                return;
            }
            this.outputTarget = new BufferedWriter(writer);
        }

        static /* synthetic */ char[] access$402(CommandContextImpl x0, char[] x1) {
            x0.password = x1;
            return x1;
        }

        private class HistoryImpl
        implements CommandHistory {
            private HistoryImpl() {
            }

            @Override
            public List<String> asList() {
                return CommandContextImpl.this.console.getHistory().getHistoryList();
            }

            @Override
            public boolean isUseHistory() {
                return CommandContextImpl.this.console.getUseHistory();
            }

            @Override
            public void setUseHistory(boolean useHistory) {
                CommandContextImpl.this.console.setUseHistory(useHistory);
            }

            @Override
            public void clear() {
                CommandContextImpl.this.console.getHistory().clear();
            }
        }

        private class AuthenticationCallbackHandler
        implements CallbackHandler {
            private String realm = null;
            private boolean realmShown = false;
            private String username;
            private char[] password;
            private String digest;

            private AuthenticationCallbackHandler(String username, char[] password) {
                this.username = username;
                this.password = password;
            }

            private AuthenticationCallbackHandler(String username, String digest) {
                this.username = username;
                this.digest = digest;
            }

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                if (callbacks.length == 1 && callbacks[0] instanceof NameCallback) {
                    ((NameCallback)callbacks[0]).setName("anonymous CLI user");
                    return;
                }
                for (Callback current : callbacks) {
                    if (current instanceof RealmCallback) {
                        String defaultText;
                        RealmCallback rcb = (RealmCallback)current;
                        this.realm = defaultText = rcb.getDefaultText();
                        rcb.setText(defaultText);
                        continue;
                    }
                    if (current instanceof RealmChoiceCallback) {
                        throw new UnsupportedCallbackException(current, "Realm choice not currently supported.");
                    }
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        if (this.username == null) {
                            this.showRealm();
                            this.username = CommandContextImpl.this.readLine("Username: ", false, true);
                            if (this.username == null || this.username.length() == 0) {
                                throw new SaslException("No username supplied.");
                            }
                        }
                        ncb.setName(this.username);
                        continue;
                    }
                    if (current instanceof PasswordCallback && this.digest == null) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        if (this.password == null) {
                            this.showRealm();
                            String temp = CommandContextImpl.this.readLine("Password: ", true, false);
                            if (temp != null) {
                                this.password = temp.toCharArray();
                            }
                        }
                        pcb.setPassword(this.password);
                        continue;
                    }
                    if (current instanceof DigestHashCallback && this.digest != null) {
                        DigestHashCallback dhc = (DigestHashCallback)current;
                        dhc.setHexHash(this.digest);
                        continue;
                    }
                    CommandContextImpl.this.printLine("Unexpected Callback " + current.getClass().getName());
                    throw new UnsupportedCallbackException(current);
                }
            }

            private void showRealm() {
                if (!this.realmShown && this.realm != null) {
                    this.realmShown = true;
                    CommandContextImpl.this.printLine("Authenticating against security realm: " + this.realm);
                }
            }
        }

        private static enum ConnectStatus {
            SUCCESS,
            AUTHENTICATION_FAILURE,
            CONNECTION_FAILURE;

        }
    }
}

