/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.impl.ConcurrentRolloutPlanGroup;
import org.jboss.as.cli.operation.impl.RolloutPlanGroup;
import org.jboss.dmr.ModelNode;

public class RolloutPlanHeader
implements OperationRequestHeader {
    private static final String HEADER_NAME = "rollout-plan";
    private final List<RolloutPlanGroup> groups = new ArrayList<RolloutPlanGroup>();
    private Map<String, String> props;

    @Override
    public String getName() {
        return HEADER_NAME;
    }

    public void addGroup(RolloutPlanGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        this.groups.add(group);
    }

    public void addConcurrentGroup(RolloutPlanGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("group is null");
        }
        int lastIndex = this.groups.size() - 1;
        if (lastIndex < 0) {
            throw new IllegalStateException("There must be a group before a concurrent group can be added.");
        }
        RolloutPlanGroup lastGroup = this.groups.get(lastIndex);
        if (lastGroup instanceof ConcurrentRolloutPlanGroup) {
            ((ConcurrentRolloutPlanGroup)lastGroup).addGroup(group);
        } else {
            ConcurrentRolloutPlanGroup concurrent = new ConcurrentRolloutPlanGroup();
            concurrent.addGroup(lastGroup);
            concurrent.addGroup(group);
            this.groups.set(lastIndex, concurrent);
        }
    }

    public void addProperty(String name, String value) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Invalid property name: " + name);
        }
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("Invalid property value: " + value);
        }
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        this.props.put(name, value);
    }

    public String getProperty(String name) {
        return this.props == null ? null : this.props.get(name);
    }

    @Override
    public void addTo(ModelNode headers) throws CommandFormatException {
        ModelNode header = headers.get(HEADER_NAME);
        ModelNode series = header.get("in-series");
        for (RolloutPlanGroup group : this.groups) {
            group.addTo(series);
        }
        if (this.props != null) {
            for (String propName : this.props.keySet()) {
                header.get(propName).set(this.props.get(propName));
            }
        }
    }
}

