/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.parsing.operation.header;

import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.RolloutPlanGroup;
import org.jboss.as.cli.operation.impl.RolloutPlanHeader;
import org.jboss.as.cli.operation.impl.SingleRolloutPlanGroup;
import org.jboss.as.cli.parsing.ParsingContext;
import org.jboss.as.cli.parsing.ParsingStateCallbackHandler;
import org.jboss.as.cli.parsing.operation.header.RolloutPlanState;
import org.jboss.as.cli.parsing.operation.header.ServerGroupListState;

public class RolloutPlanHeaderCallbackHandler
implements ParsingStateCallbackHandler {
    private final RolloutPlanHeader header = new RolloutPlanHeader();
    private final DefaultCallbackHandler handler;
    final StringBuilder buffer = new StringBuilder();
    private String name;
    private RolloutPlanGroup group;
    private boolean concurrent;

    public RolloutPlanHeaderCallbackHandler(DefaultCallbackHandler handler) {
        this.handler = handler;
    }

    @Override
    public void enteredState(ParsingContext ctx) throws CommandFormatException {
        String id = ctx.getState().getId();
        if ("HEADER_VALUE".equals(id)) {
            ctx.enterState(RolloutPlanState.INSTANCE);
        } else if ("SG".equals(id)) {
            this.group = new SingleRolloutPlanGroup();
        } else if ("CONCURRENT".equals(id)) {
            this.concurrent = true;
        } else if ("NAME_VALUE_SEPARATOR".equals(id)) {
            String string = this.name = this.buffer.length() == 0 ? null : this.buffer.toString().trim();
            if (this.name == null || this.name.isEmpty()) {
                throw new CommandFormatException("Property is missing name at index " + ctx.getLocation());
            }
            if (this.name.equals("in-series")) {
                ctx.enterState(ServerGroupListState.INSTANCE);
            }
        }
        this.buffer.setLength(0);
    }

    @Override
    public void leavingState(ParsingContext ctx) throws CommandFormatException {
        String id = ctx.getState().getId();
        if (id.equals("HEADER_VALUE")) {
            this.handler.header(this.header);
        } else if ("PROP_VALUE".equals(id)) {
            String value;
            String string = value = this.buffer.length() == 0 ? null : this.buffer.toString().trim();
            if (value == null || value.isEmpty()) {
                throw new CommandFormatException("Property '" + this.name + "' is missing value at index " + ctx.getLocation());
            }
            if (this.group != null) {
                ((SingleRolloutPlanGroup)this.group).addProperty(this.name, value);
            } else {
                this.header.addProperty(this.name, value);
            }
            this.name = null;
        } else if ("SG_NAME".equals(id)) {
            String groupName = this.buffer.toString().trim();
            if (groupName.isEmpty()) {
                throw new CommandFormatException("Empty group name at index " + ctx.getLocation());
            }
            ((SingleRolloutPlanGroup)this.group).setGroupName(groupName);
        } else if ("SG".equals(id)) {
            if (this.concurrent) {
                this.header.addConcurrentGroup(this.group);
                this.concurrent = false;
            } else {
                this.header.addGroup(this.group);
            }
            this.group = null;
        }
    }

    @Override
    public void character(ParsingContext ctx) throws CommandFormatException {
        this.buffer.append(ctx.getCharacter());
    }
}

