/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.operation.ParsedCommandLine;

public class ConnectHandler
extends CommandHandlerWithHelp {
    public ConnectHandler() {
        this("connect");
    }

    public ConnectHandler(String command) {
        super(command);
    }

    @Override
    public boolean hasArgument(int index) {
        return index <= 1;
    }

    @Override
    protected void doHandle(CommandContext ctx) {
        int port = -1;
        String host = null;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        List<String> args = parsedCmd.getOtherProperties();
        if (!args.isEmpty()) {
            if (args.size() != 1) {
                ctx.printLine("The command expects only one argument but got " + args);
                return;
            }
            String arg = args.get(0);
            String portStr = null;
            int colonIndex = arg.lastIndexOf(58);
            if (colonIndex < 0) {
                host = arg;
            } else if (colonIndex == 0) {
                portStr = arg.substring(1).trim();
            } else {
                int closeBracket = arg.lastIndexOf(93);
                boolean hasPort = closeBracket != -1 ? closeBracket <= colonIndex : true;
                if (hasPort) {
                    host = arg.substring(0, colonIndex).trim();
                    portStr = arg.substring(colonIndex + 1).trim();
                } else {
                    host = arg;
                }
            }
            if (portStr != null) {
                try {
                    port = Integer.parseInt(portStr);
                }
                catch (NumberFormatException e) {
                    ctx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                    return;
                }
                if (port < 0) {
                    ctx.printLine("The port must be a valid non-negative integer: '" + args + "'");
                    return;
                }
            }
        }
        ctx.connectController(host, port);
    }
}

