/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.jms;

import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.BatchModeCommandHandler;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.DefaultCompleter;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.dmr.ModelNode;

public class JmsQueueAddHandler
extends BatchModeCommandHandler {
    private final ArgumentWithValue name;
    private final ArgumentWithValue entries;
    private final ArgumentWithValue selector;
    private final ArgumentWithValue durable;
    private final ArgumentWithValue profile = new ArgumentWithValue(this, new DefaultCompleter(new DefaultCompleter.CandidatesProvider(){

        public List<String> getAllCandidates(CommandContext ctx) {
            return Util.getNodeNames(ctx.getModelControllerClient(), null, "profile");
        }
    }), "--profile"){

        @Override
        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
            if (!ctx.isDomainMode()) {
                return false;
            }
            return super.canAppearNext(ctx);
        }
    };

    public JmsQueueAddHandler(CommandContext ctx) {
        super(ctx, "jms-queue-add", true);
        this.name = new ArgumentWithValue(this, "--name"){

            @Override
            public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                if (ctx.isDomainMode() && !JmsQueueAddHandler.this.profile.isValueComplete(ctx.getParsedCommandLine())) {
                    return false;
                }
                return super.canAppearNext(ctx);
            }
        };
        this.entries = new ArgumentWithValue(this, "--entries");
        this.entries.addRequiredPreceding(this.name);
        this.selector = new ArgumentWithValue(this, "--selector");
        this.selector.addRequiredPreceding(this.name);
        this.durable = new ArgumentWithValue((CommandHandlerWithArguments)this, new SimpleTabCompleter(new String[]{"false", "true"}), "--durable");
        this.durable.addRequiredPreceding(this.name);
        this.addRequiredPath("/subsystem=messaging");
    }

    @Override
    public ModelNode buildRequest(CommandContext ctx) throws CommandFormatException {
        String durable;
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder();
        ParsedCommandLine args = ctx.getParsedCommandLine();
        if (ctx.isDomainMode()) {
            String profile = this.profile.getValue(args);
            if (profile == null) {
                throw new OperationFormatException("--profile argument value is missing.");
            }
            builder.addNode("profile", profile);
        }
        String name = this.name.getValue(args, true);
        String serverName = "default";
        builder.addNode("subsystem", "messaging");
        builder.addNode("hornetq-server", serverName);
        builder.addNode("jms-queue", name);
        builder.setOperationName("add");
        ModelNode entriesNode = builder.getModelNode().get("entries");
        String entriesStr = this.entries.getValue(args);
        if (entriesStr == null) {
            entriesNode.add(name);
        } else {
            String[] split = entriesStr.split(",");
            for (int i = 0; i < split.length; ++i) {
                String entry = split[i].trim();
                if (entry.isEmpty()) continue;
                entriesNode.add(entry);
            }
        }
        String selector = this.selector.getValue(args);
        if (selector != null) {
            builder.addProperty("selector", selector);
        }
        if ((durable = this.durable.getValue(args)) != null) {
            builder.addProperty("durable", durable);
        }
        return builder.buildRequest();
    }
}

