/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli;

import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    protected static String getSystemProperty(String name) {
        return TCLAction.UTIL.getSystemProperty(name);
    }

    private static interface TCLAction {
        public static final TCLAction NON_PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(String name) {
                return System.getProperty(name);
            }
        };
        public static final TCLAction PRIVILEGED = new TCLAction(){

            @Override
            public String getSystemProperty(final String name) {
                return (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return System.getProperty(name);
                    }
                });
            }
        };

        public String getSystemProperty(String var1);

        public static class UTIL {
            static TCLAction getTCLAction() {
                return System.getSecurityManager() == null ? NON_PRIVILEGED : PRIVILEGED;
            }

            public static String getSystemProperty(String name) {
                return UTIL.getTCLAction().getSystemProperty(name);
            }
        }
    }
}

