/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import java.io.Serializable;
import java.util.AbstractMap;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.as.clustering.HashableMarshalledValueFactory;
import org.jboss.as.clustering.MarshalledValue;
import org.jboss.as.clustering.MarshalledValueFactory;
import org.jboss.as.clustering.MarshallingContext;
import org.jboss.as.clustering.SimpleMarshalledValueFactory;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.InfinispanBackingCacheEntryStore;
import org.jboss.as.clustering.ejb3.cache.backing.infinispan.LockKeyFactory;
import org.jboss.as.clustering.impl.CoreGroupCommunicationService;
import org.jboss.as.clustering.infinispan.invoker.CacheInvoker;
import org.jboss.as.clustering.infinispan.invoker.RetryingCacheInvoker;
import org.jboss.as.clustering.infinispan.subsystem.CacheService;
import org.jboss.as.clustering.lock.SharedLocalYieldingClusterLockManager;
import org.jboss.as.clustering.lock.impl.SharedLocalYieldingClusterLockManagerService;
import org.jboss.as.clustering.registry.Registry;
import org.jboss.as.clustering.registry.RegistryService;
import org.jboss.as.ejb3.cache.Cacheable;
import org.jboss.as.ejb3.cache.PassivationManager;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreConfig;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.cache.impl.backing.clustering.ClusteredBackingCacheEntryStoreSourceService;
import org.jboss.as.ejb3.cache.spi.BackingCacheEntryStore;
import org.jboss.as.ejb3.cache.spi.SerializationGroup;
import org.jboss.as.ejb3.cache.spi.SerializationGroupMember;
import org.jboss.as.ejb3.cache.spi.impl.AbstractBackingCacheEntryStoreSource;
import org.jboss.as.ejb3.component.stateful.StatefulTimeoutInfo;
import org.jboss.as.ejb3.remote.EJBRemotingConnectorClientMappingsEntryProviderService;
import org.jboss.marshalling.MarshallerFactory;
import org.jboss.marshalling.Marshalling;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class InfinispanBackingCacheEntryStoreSource<K extends Serializable, V extends Cacheable<K>, G extends Serializable>
extends AbstractBackingCacheEntryStoreSource<K, V, G>
implements ClusteredBackingCacheEntryStoreSource<K, V, G> {
    public static final short SCOPE_ID = 223;
    private String cacheContainerName = "ejb";
    private String beanCacheName = DEFAULT_BEAN_CACHE;
    private String clientMappingsCacheName = "remote-connector-client-mappings";
    private int maxSize = 10000;
    private boolean passivateEventsOnReplicate = true;
    private final MarshallerFactory factory = Marshalling.getMarshallerFactory((String)"river", (ClassLoader)MarshallerFactory.class.getClassLoader());
    private CacheInvoker invoker = new RetryingCacheInvoker(new int[]{0, 0});
    private final InjectedValue<Cache> groupCache = new InjectedValue();
    private final InjectedValue<SharedLocalYieldingClusterLockManager> lockManager = new InjectedValue();
    private final InjectedValue<Registry> registry = new InjectedValue();

    public void addDependencies(ServiceTarget target, ServiceBuilder<?> builder) {
        ServiceName groupCacheServiceName = CacheService.getServiceName((String)this.cacheContainerName, (String)this.beanCacheName);
        new CoreGroupCommunicationService(223).build(target, this.cacheContainerName).addDependency(groupCacheServiceName).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        new SharedLocalYieldingClusterLockManagerService(this.cacheContainerName).build(target).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
        builder.addDependency(groupCacheServiceName, Cache.class, this.groupCache);
        builder.addDependency(SharedLocalYieldingClusterLockManagerService.getServiceName((String)this.cacheContainerName), SharedLocalYieldingClusterLockManager.class, this.lockManager);
        ServiceName registryServiceName = ClusteredBackingCacheEntryStoreSourceService.getClientMappingRegistryServiceName((String)this.cacheContainerName);
        builder.addDependency(registryServiceName, Registry.class, this.registry);
        InjectedValue registryEntryProvider = new InjectedValue();
        RegistryService registryService = new RegistryService((Registry.RegistryEntryProvider)new RegistryEntryProviderValue((Value<Registry.RegistryEntryProvider>)registryEntryProvider));
        registryService.build(target, registryServiceName, CacheService.getServiceName((String)this.cacheContainerName, (String)this.clientMappingsCacheName)).addDependency(EJBRemotingConnectorClientMappingsEntryProviderService.SERVICE_NAME, Registry.RegistryEntryProvider.class, (Injector)registryEntryProvider).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
    }

    public <E extends SerializationGroup<K, V, G>> BackingCacheEntryStore<G, Cacheable<G>, E> createGroupIntegratedObjectStore(PassivationManager<G, E> passivationManager, StatefulTimeoutInfo timeout) {
        AdvancedCache cache = ((Cache)this.groupCache.getValue()).getAdvancedCache().with(((Object)((Object)this)).getClass().getClassLoader());
        MarshallingContext context = new MarshallingContext(this.factory, passivationManager.getMarshallingConfiguration());
        HashableMarshalledValueFactory keyFactory = new HashableMarshalledValueFactory(context);
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory(context);
        Registry registry = (Registry)this.registry.getValue();
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, false, (MarshalledValueFactory<MarshallingContext>)keyFactory, (MarshalledValueFactory<MarshallingContext>)valueFactory, context, null, null, (Registry<String, ?>)registry);
    }

    public <E extends SerializationGroupMember<K, V, G>> BackingCacheEntryStore<K, V, E> createIntegratedObjectStore(final String beanName, PassivationManager<K, E> passivationManager, StatefulTimeoutInfo timeout) {
        Cache groupCache = (Cache)this.groupCache.getValue();
        Configuration groupCacheConfiguration = groupCache.getCacheConfiguration();
        EmbeddedCacheManager container = groupCache.getCacheManager();
        ConfigurationBuilder builder = new ConfigurationBuilder().read(groupCacheConfiguration);
        if (this.maxSize > 0) {
            builder.eviction().strategy(EvictionStrategy.LRU).maxEntries(this.maxSize);
        }
        groupCache.getCacheManager().defineConfiguration(beanName, builder.build());
        AdvancedCache cache = container.getCache(beanName).getAdvancedCache().with(((Object)((Object)this)).getClass().getClassLoader());
        MarshallingContext context = new MarshallingContext(this.factory, passivationManager.getMarshallingConfiguration());
        HashableMarshalledValueFactory keyFactory = new HashableMarshalledValueFactory(context);
        SimpleMarshalledValueFactory valueFactory = new SimpleMarshalledValueFactory(context);
        LockKeyFactory lockKeyFactory = new LockKeyFactory<K, MarshallingContext>(){

            @Override
            public Serializable createLockKey(MarshalledValue<K, MarshallingContext> key) {
                return new AbstractMap.SimpleImmutableEntry(key, beanName);
            }
        };
        Registry registry = (Registry)this.registry.getValue();
        return new InfinispanBackingCacheEntryStore(cache, this.invoker, this.passivateEventsOnReplicate ? passivationManager : null, timeout, (ClusteredBackingCacheEntryStoreConfig)this, true, (MarshalledValueFactory<MarshallingContext>)keyFactory, (MarshalledValueFactory<MarshallingContext>)valueFactory, context, (SharedLocalYieldingClusterLockManager)this.lockManager.getValue(), lockKeyFactory, (Registry<String, ?>)registry);
    }

    public String getCacheContainer() {
        return this.cacheContainerName;
    }

    public void setCacheContainer(String cacheContainerName) {
        this.cacheContainerName = cacheContainerName;
    }

    public String getClientMappingCache() {
        return this.clientMappingsCacheName;
    }

    public void setClientMappingCache(String cacheName) {
        this.clientMappingsCacheName = cacheName;
    }

    public String getBeanCache() {
        return this.beanCacheName;
    }

    public void setBeanCache(String cacheName) {
        this.beanCacheName = cacheName;
    }

    public boolean isPassivateEventsOnReplicate() {
        return this.passivateEventsOnReplicate;
    }

    public void setPassivateEventsOnReplicate(boolean passivateEventsOnReplicate) {
        this.passivateEventsOnReplicate = passivateEventsOnReplicate;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    private class RegistryEntryProviderValue
    implements Registry.RegistryEntryProvider<String, Object> {
        private final Value<Registry.RegistryEntryProvider> provider;

        RegistryEntryProviderValue(Value<Registry.RegistryEntryProvider> provider) {
            this.provider = provider;
        }

        public String getKey() {
            Registry.RegistryEntryProvider provider = (Registry.RegistryEntryProvider)this.provider.getValue();
            return (String)provider.getKey();
        }

        public Object getValue() {
            Registry.RegistryEntryProvider provider = (Registry.RegistryEntryProvider)this.provider.getValue();
            return provider.getValue();
        }
    }
}

