/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.ejb3.cache.backing.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import org.jboss.as.clustering.infinispan.io.AbstractSimpleExternalizer;
import org.jboss.as.network.ClientMapping;

public class ClientMappingExternalizer
extends AbstractSimpleExternalizer<ClientMapping> {
    public ClientMappingExternalizer() {
        super(ClientMapping.class);
    }

    public void writeObject(ObjectOutput output, ClientMapping mapping) throws IOException {
        byte[] address = mapping.getSourceNetworkAddress().getAddress();
        output.writeInt(address.length);
        output.write(address);
        output.writeInt(mapping.getSourceNetworkMaskBits());
        output.writeUTF(mapping.getDestinationAddress());
        output.writeInt(mapping.getDestinationPort());
    }

    public ClientMapping readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        byte[] sourceAddress = new byte[input.readInt()];
        input.read(sourceAddress);
        int sourcePort = input.readInt();
        String destAddress = input.readUTF();
        int destPort = input.readInt();
        return new ClientMapping(InetAddress.getByAddress(sourceAddress), sourcePort, destAddress, destPort);
    }
}

