/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.InetSocketAddress;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.jboss.as.clustering.AsynchEventHandler;
import org.jboss.as.clustering.ClusterNode;
import org.jboss.as.clustering.ClusterNodeFactory;
import org.jboss.as.clustering.ClusterNodeImpl;
import org.jboss.as.clustering.GroupCommunicationService;
import org.jboss.as.clustering.GroupMembershipListener;
import org.jboss.as.clustering.GroupMembershipNotifier;
import org.jboss.as.clustering.GroupRpcDispatcher;
import org.jboss.as.clustering.GroupStateTransferService;
import org.jboss.as.clustering.ResponseFilter;
import org.jboss.as.clustering.RspFilterAdapter;
import org.jboss.as.clustering.SerializableStateTransferResult;
import org.jboss.as.clustering.StateTransferProvider;
import org.jboss.as.clustering.StateTransferResult;
import org.jboss.as.clustering.StateTransferStreamProvider;
import org.jboss.as.clustering.StreamStateTransferResult;
import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.mux.DelegatingStateTransferUpHandler;
import org.jboss.as.clustering.jgroups.mux.MuxUpHandler;
import org.jboss.as.clustering.jgroups.mux.StateTransferFilter;
import org.jboss.logging.Logger;
import org.jboss.util.loading.ContextClassLoaderSwitcher;
import org.jboss.util.stream.MarshalledValueInputStream;
import org.jboss.util.stream.MarshalledValueOutputStream;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.Event;
import org.jgroups.ExtendedMembershipListener;
import org.jgroups.ExtendedMessageListener;
import org.jgroups.MembershipListener;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.MessageListener;
import org.jgroups.UpHandler;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.blocks.MethodCall;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.blocks.RspFilter;
import org.jgroups.blocks.mux.MuxRpcDispatcher;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.blocks.mux.NoMuxHandler;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class CoreGroupCommunicationService
implements GroupRpcDispatcher,
GroupMembershipNotifier,
GroupStateTransferService {
    private static final byte NULL_VALUE = 0;
    private static final byte SERIALIZABLE_VALUE = 1;
    private ChannelFactory channelFactory;
    private String stackName;
    private String groupName;
    private boolean channelSelfConnected;
    Channel channel;
    private Address localJGAddress = null;
    ClusterNode me = null;
    private volatile GroupView groupView = new GroupView();
    private long method_call_timeout = 60000L;
    Short scopeId;
    private RpcDispatcher dispatcher = null;
    final Map<String, Object> rpcHandlers = new ConcurrentHashMap<String, Object>();
    private boolean directlyInvokeLocal;
    final Map<String, WeakReference<ClassLoader>> clmap = new ConcurrentHashMap<String, WeakReference<ClassLoader>>();
    private boolean allowSyncListeners = false;
    final ArrayList<GroupMembershipListener> asyncMembershipListeners = new ArrayList();
    private final ArrayList<GroupMembershipListener> syncMembershipListeners = new ArrayList();
    private AsynchEventHandler asynchHandler;
    private long state_transfer_timeout = 60000L;
    String stateIdPrefix;
    final Map<String, StateTransferProvider> stateProviders = new HashMap<String, StateTransferProvider>();
    final Map<String, StateTransferTask<?, ?>> stateTransferTasks = new Hashtable();
    final ContextClassLoaderSwitcher classLoaderSwitcher = (ContextClassLoaderSwitcher)AccessController.doPrivileged(ContextClassLoaderSwitcher.INSTANTIATOR);
    protected Logger log = Logger.getLogger((String)this.getClass().getName());
    Logger clusterLifeCycleLog = Logger.getLogger((String)(this.getClass().getName() + ".lifecycle"));
    private final Vector<String> history = new Vector();
    private int maxHistoryLength = 100;
    Executor threadPool;
    final ThreadGate flushBlockGate = new ThreadGate();
    private final ClusterNodeFactory nodeFactory = new ClusterNodeFactoryImpl();
    final Object channelLock = new Object();
    private State state = State.UNREGISTERED;

    public boolean isConsistentWith(GroupCommunicationService other) {
        return this == other;
    }

    public String getNodeName() {
        return this.me == null ? null : this.me.getName();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Vector<String> getCurrentView() {
        GroupView curView = this.groupView;
        Vector<String> result = new Vector<String>(curView.allMembers.size());
        for (ClusterNode member : curView.allMembers) {
            result.add(member.getName());
        }
        return result;
    }

    public long getCurrentViewId() {
        return this.groupView.viewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterNode[] getClusterNodes() {
        GroupView curView = this.groupView;
        Vector<ClusterNode> vector = curView.allMembers;
        synchronized (vector) {
            return curView.allMembers.toArray(new ClusterNode[curView.allMembers.size()]);
        }
    }

    public ClusterNode getClusterNode() {
        return this.me;
    }

    public boolean isCurrentNodeCoordinator() {
        GroupView curView = this.groupView;
        if (curView.allMembers.size() == 0 || this.me == null) {
            return false;
        }
        return curView.allMembers.elementAt(0).equals(this.me);
    }

    public void registerRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.put(objName, subscriber);
    }

    public void registerRPCHandler(String objName, Object subscriber, ClassLoader classloader) {
        this.registerRPCHandler(objName, subscriber);
        this.clmap.put(objName, new WeakReference<ClassLoader>(classloader));
    }

    public void unregisterRPCHandler(String objName, Object subscriber) {
        this.rpcHandlers.remove(objName);
        this.clmap.remove(objName);
    }

    public ArrayList<?> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws InterruptedException {
        return this.callMethodOnCluster(serviceName, methodName, args, (Class[])types, Object.class, excludeSelf, (ResponseFilter)null, this.getMethodCallTimeout(), false);
    }

    public ArrayList<?> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, ResponseFilter filter) throws InterruptedException {
        return this.callMethodOnCluster(serviceName, methodName, args, (Class[])types, Object.class, excludeSelf, filter, this.getMethodCallTimeout(), false);
    }

    public <T> ArrayList<T> callMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, Class<T> returnType, boolean excludeSelf, ResponseFilter filter, long methodTimeout, boolean unordered) throws InterruptedException {
        boolean trace;
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        RspFilterAdapter rspFilter = filter == null ? null : new RspFilterAdapter(filter, this.nodeFactory);
        RequestOptions ro = new RequestOptions(2, methodTimeout, false, (RspFilter)rspFilter);
        if (excludeSelf) {
            ro.setExclusionList(new Address[]{this.localJGAddress});
        }
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getMethodCallTimeout());
        }
        if (trace = this.log.isTraceEnabled()) {
            this.log.trace((Object)("calling synchronous method on cluster, serviceName=" + serviceName + ", methodName=" + methodName + ", members=" + this.groupView + ", excludeSelf=" + excludeSelf));
        }
        RspList rsp = this.dispatcher.callRemoteMethods(null, m, ro);
        ArrayList<T> result = this.processResponseList(rsp, returnType, trace);
        if (!excludeSelf && this.directlyInvokeLocal && (filter == null || filter.needMoreResponses())) {
            try {
                this.invokeDirectly(serviceName, methodName, args, types, returnType, result, filter);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    <T> T invokeDirectly(String serviceName, String methodName, Object[] args, Class<?>[] types, Class<T> returnType, List<T> remoteResponses, ResponseFilter filter) throws Exception {
        Object retVal = null;
        Object handler = this.rpcHandlers.get(serviceName);
        if (handler != null) {
            MethodCall call = new MethodCall(methodName, args, (Class[])types);
            try {
                Object result = call.invoke(handler);
                if (returnType != null && Void.TYPE != returnType) {
                    retVal = returnType.cast(result);
                    if (remoteResponses != null && (filter == null || filter.isAcceptable(retVal, this.me))) {
                        remoteResponses.add(retVal);
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        return (T)retVal;
    }

    public Object callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws Exception {
        return this.callMethodOnCoordinatorNode(serviceName, methodName, args, types, Object.class, excludeSelf, this.getMethodCallTimeout(), false);
    }

    public <T> T callMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, Class<T> returnType, boolean excludeSelf, long methodTimeout, boolean unordered) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            this.log.trace((Object)("callMethodOnCoordinatorNode(false), objName=" + serviceName + ", methodName=" + methodName));
        }
        if (returnType == null) {
            Class<Void> unchecked = Void.TYPE;
            returnType = unchecked;
        }
        if (this.isCurrentNodeCoordinator()) {
            if (excludeSelf) {
                return null;
            }
            if (this.directlyInvokeLocal) {
                return this.invokeDirectly(serviceName, methodName, args, types, returnType, null, null);
            }
        }
        Address coord = this.groupView.coordinator;
        RequestOptions opt = new RequestOptions(2, methodTimeout);
        if (unordered) {
            opt.setFlags((byte)1);
        }
        try {
            return (T)returnType.cast(this.dispatcher.callRemoteMethod(coord, m, opt));
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Caught raw Throwable on remote invocation", e);
        }
    }

    public Object callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode) throws Exception {
        return this.callMethodOnNode(serviceName, methodName, args, types, Object.class, this.getMethodCallTimeout(), targetNode, false);
    }

    public Object callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, long methodTimeout, ClusterNode targetNode) throws Exception {
        return this.callMethodOnNode(serviceName, methodName, args, types, Object.class, methodTimeout, targetNode, false);
    }

    public <T> T callMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, Class<T> returnType, long methodTimeout, ClusterNode targetNode, boolean unordered) throws Exception {
        if (returnType == null) {
            Class<Void> unchecked = Void.TYPE;
            returnType = unchecked;
        }
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw new IllegalArgumentException("targetNode " + targetNode + " is not an instance of " + ClusterNodeImpl.class + " -- only targetNodes provided by this HAPartition should be used");
        }
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            this.log.trace((Object)("callMethodOnNode( objName=" + serviceName + ", methodName=" + methodName));
        }
        if (this.directlyInvokeLocal && this.me.equals(targetNode)) {
            return this.invokeDirectly(serviceName, methodName, args, types, returnType, null, null);
        }
        Object rsp = null;
        RequestOptions opt = new RequestOptions(1, methodTimeout);
        if (unordered) {
            opt.setFlags((byte)1);
        }
        try {
            rsp = this.dispatcher.callRemoteMethod(((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Caught raw Throwable on remote invocation", e);
        }
        if (rsp instanceof NoHandlerForRPC) {
            this.log.trace((Object)"Ignoring NoHandlerForRPC");
            rsp = null;
        }
        return (T)returnType.cast(rsp);
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode) throws Exception {
        this.callAsyncMethodOnNode(serviceName, methodName, args, types, targetNode, false);
    }

    public void callAsyncMethodOnNode(String serviceName, String methodName, Object[] args, Class<?>[] types, ClusterNode targetNode, boolean unordered) throws Exception {
        if (!(targetNode instanceof ClusterNodeImpl)) {
            throw new IllegalArgumentException("targetNode " + targetNode + " is not an instance of " + ClusterNodeImpl.class + " -- only targetNodes provided by this HAPartition should be used");
        }
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            this.log.trace((Object)("callAsyncMethodOnNode( objName=" + serviceName + ", methodName=" + methodName));
        }
        if (this.directlyInvokeLocal && this.me.equals(targetNode)) {
            new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
            return;
        }
        RequestOptions opt = new RequestOptions(6, this.getMethodCallTimeout());
        if (unordered) {
            opt.setFlags((byte)1);
        }
        try {
            this.dispatcher.callRemoteMethod(((ClusterNodeImpl)targetNode).getOriginalJGAddress(), m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Caught raw Throwable on remote invocation", e);
        }
    }

    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws InterruptedException {
        this.callAsynchMethodOnCluster(serviceName, methodName, args, types, excludeSelf, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callAsynchMethodOnCluster(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, boolean unordered) throws InterruptedException {
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        RequestOptions ro = new RequestOptions(6, this.getMethodCallTimeout());
        if (excludeSelf) {
            ro.setExclusionList(new Address[]{this.localJGAddress});
        }
        if (this.channel.flushSupported()) {
            this.flushBlockGate.await(this.getMethodCallTimeout());
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("calling asynch method on cluster, serviceName=" + serviceName + ", methodName=" + methodName + ", members=" + this.groupView + ", excludeSelf=" + excludeSelf));
        }
        try {
            this.dispatcher.callRemoteMethods(null, m, ro);
        }
        finally {
            if (!excludeSelf && this.directlyInvokeLocal) {
                new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
            }
        }
    }

    public void callAsyncMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf) throws Exception {
        this.callAsyncMethodOnCoordinatorNode(serviceName, methodName, args, types, excludeSelf, false);
    }

    public void callAsyncMethodOnCoordinatorNode(String serviceName, String methodName, Object[] args, Class<?>[] types, boolean excludeSelf, boolean unordered) throws Exception {
        boolean trace = this.log.isTraceEnabled();
        MethodCall m = new MethodCall(serviceName + "." + methodName, args, (Class[])types);
        if (trace) {
            this.log.trace((Object)("callMethodOnCoordinatorNode(false), objName=" + serviceName + ", methodName=" + methodName));
        }
        if (this.isCurrentNodeCoordinator()) {
            if (!excludeSelf) {
                if (this.directlyInvokeLocal) {
                    new AsynchronousLocalInvocation(serviceName, methodName, args, types).invoke();
                }
            } else {
                return;
            }
        }
        Address coord = this.groupView.coordinator;
        RequestOptions opt = new RequestOptions(2, this.getMethodCallTimeout());
        if (unordered) {
            opt.setFlags((byte)1);
        }
        try {
            this.dispatcher.callRemoteMethod(coord, m, opt);
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("Caught raw Throwable on remote invocation", e);
        }
    }

    public boolean getAllowSynchronousMembershipNotifications() {
        return this.allowSyncListeners;
    }

    public void setAllowSynchronousMembershipNotifications(boolean allowSync) {
        this.allowSyncListeners = allowSync;
    }

    public void registerGroupMembershipListener(GroupMembershipListener listener) {
        this.registerGroupMembershipListener(listener, false);
    }

    public void unregisterGroupMembershipListener(GroupMembershipListener listener) {
        this.unregisterGroupMembershipListener(listener, false);
    }

    public long getStateTransferTimeout() {
        return this.state_transfer_timeout;
    }

    public void setStateTransferTimeout(long timeout) {
        this.state_transfer_timeout = timeout;
    }

    public Future<SerializableStateTransferResult> getServiceState(String serviceName, ClassLoader classloader) {
        FutureTask<SerializableStateTransferResult> future = null;
        StateTransferTask<?, ?> task = this.stateTransferTasks.get(serviceName);
        if (task == null || task.result != null && !task.result.stateReceived()) {
            SerializableStateTransferTask newTask = new SerializableStateTransferTask(serviceName, classloader);
            this.stateTransferTasks.put(serviceName, newTask);
            future = new FutureTask<SerializableStateTransferResult>(newTask);
        } else if (task instanceof SerializableStateTransferTask) {
            this.log.warn((Object)("Received concurrent requests to get service state for " + serviceName));
            future = new FutureTask<SerializableStateTransferResult>((SerializableStateTransferTask)task);
        } else {
            throw new IllegalStateException("State transfer task for " + serviceName + " that will return an input stream is already pending");
        }
        Executor e = this.getThreadPool();
        if (e == null) {
            e = Executors.newSingleThreadExecutor();
        }
        e.execute(future);
        return future;
    }

    public Future<SerializableStateTransferResult> getServiceState(String serviceName) {
        return this.getServiceState(serviceName, null);
    }

    public Future<StreamStateTransferResult> getServiceStateAsStream(String serviceName) {
        FutureTask<StreamStateTransferResult> future = null;
        StateTransferTask<?, ?> task = this.stateTransferTasks.get(serviceName);
        if (task == null || task.result != null && !task.result.stateReceived()) {
            StreamStateTransferTask newTask = new StreamStateTransferTask(serviceName);
            this.stateTransferTasks.put(serviceName, newTask);
            future = new FutureTask<StreamStateTransferResult>(newTask);
        } else if (task instanceof StreamStateTransferTask) {
            this.log.warn((Object)("Received concurrent requests to get service state for " + serviceName));
            future = new FutureTask<StreamStateTransferResult>((StreamStateTransferTask)task);
        } else {
            throw new IllegalStateException("State transfer task for " + serviceName + " that will return an deserialized object is already pending");
        }
        Executor e = this.getThreadPool();
        if (e == null) {
            e = Executors.newSingleThreadExecutor();
        }
        e.execute(future);
        return future;
    }

    public void registerStateTransferProvider(String serviceName, StateTransferProvider provider) {
        this.stateProviders.put(serviceName, provider);
    }

    public void unregisterStateTransferProvider(String serviceName) {
        this.stateProviders.remove(serviceName);
    }

    public String showHistory() {
        StringBuffer buff = new StringBuffer();
        Vector<String> data = new Vector<String>(this.history);
        for (String info : data) {
            buff.append(info).append("\n");
        }
        return buff.toString();
    }

    public String showHistoryAsXML() {
        StringBuffer buff = new StringBuffer();
        buff.append("<events>\n");
        Vector<String> data = new Vector<String>(this.history);
        Iterator<String> row = data.iterator();
        while (row.hasNext()) {
            buff.append("   <event>\n      ");
            String info = row.next();
            buff.append(info);
            buff.append("\n   </event>\n");
        }
        buff.append("</events>\n");
        return buff.toString();
    }

    public Short getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(Short scopeId) {
        this.scopeId = scopeId;
    }

    public int getMaxHistoryLength() {
        return this.maxHistoryLength;
    }

    public void setMaxHistoryLength(int maxHistoryLength) {
        this.maxHistoryLength = maxHistoryLength;
    }

    public Executor getThreadPool() {
        return this.threadPool;
    }

    public void setThreadPool(Executor threadPool) {
        this.threadPool = threadPool;
    }

    public String getJGroupsVersion() {
        return "2.12.1.Final( " + Version.string_version + ")";
    }

    public ChannelFactory getChannelFactory() {
        return this.channelFactory;
    }

    public void setChannelFactory(ChannelFactory factory) {
        this.channelFactory = factory;
    }

    public String getChannelStackName() {
        return this.stackName;
    }

    public void setChannelStackName(String stackName) {
        this.stackName = stackName;
    }

    public long getMethodCallTimeout() {
        return this.method_call_timeout;
    }

    public void setMethodCallTimeout(long timeout) {
        this.method_call_timeout = timeout;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setChannel(Channel channel) {
        this.channel = channel;
        this.groupName = channel.getClusterName();
    }

    public void create() throws Exception {
        if (this.state == State.CREATED || this.state == State.STARTING || this.state == State.STARTED || this.state == State.STOPPING || this.state == State.STOPPED) {
            this.log.debug((Object)("Ignoring create call; current state is " + (Object)((Object)this.state)));
            return;
        }
        this.createService();
        this.state = State.CREATED;
    }

    public void start() throws Exception {
        if (this.state == State.STARTING || this.state == State.STARTED || this.state == State.STOPPING) {
            this.log.debug((Object)("Ignoring start call; current state is " + (Object)((Object)this.state)));
            return;
        }
        if (this.state != State.CREATED && this.state != State.STOPPED && this.state != State.FAILED) {
            this.log.debug((Object)"Start requested before create, calling create now");
            this.create();
        }
        this.state = State.STARTING;
        try {
            this.startService();
            this.state = State.STARTED;
        }
        catch (Throwable t) {
            this.state = State.FAILED;
            if (this.channel != null && this.channelSelfConnected) {
                this.log.debug((Object)("Caught exception after channel connected; closing channel -- " + t.getLocalizedMessage()));
                this.channel.close();
                this.channel = null;
            }
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new RuntimeException(t);
        }
    }

    public void stop() {
        if (this.state != State.STARTED) {
            this.log.debug((Object)("Ignoring stop call; current state is " + (Object)((Object)this.state)));
            return;
        }
        this.state = State.STOPPING;
        try {
            this.stopService();
            this.state = State.STOPPED;
        }
        catch (InterruptedException e) {
            this.state = State.FAILED;
            Thread.currentThread().interrupt();
            this.log.warn((Object)"Exception in stop ", (Throwable)e);
        }
        catch (Exception e) {
            this.state = State.FAILED;
            this.log.warn((Object)"Exception in stop ", (Throwable)e);
        }
        catch (Error e) {
            this.state = State.FAILED;
            throw e;
        }
    }

    public void destroy() {
        if (this.state == State.DESTROYED) {
            this.log.debug((Object)("Ignoring destroy call; current state is " + (Object)((Object)this.state)));
            return;
        }
        if (this.state == State.STARTED) {
            this.log.debug((Object)"Destroy requested before stop, calling stop now");
            this.stop();
        }
        try {
            this.destroyService();
        }
        catch (Exception e) {
            this.log.error((Object)"Error destroying service", (Throwable)e);
        }
        this.state = State.DESTROYED;
    }

    public State getState() {
        return this.state;
    }

    protected void createService() throws Exception {
        this.setupLoggers(this.getGroupName());
        this.asynchHandler = new AsynchEventHandler(new ViewChangeEventProcessor(), "AsynchViewChangeHandler");
    }

    protected void startService() throws Exception {
        if (this.scopeId == null) {
            throw new IllegalStateException("Must set scopeId before calling start()");
        }
        this.stateIdPrefix = this.getClass().getName() + "." + this.scopeId + ".";
        if (this.channel == null || !this.channel.isOpen()) {
            this.log.debug((Object)("Creating Channel for partition " + this.getGroupName() + " using stack " + this.getChannelStackName()));
            this.channel = this.createChannel();
        }
        MembershipListenerImpl meml = new MembershipListenerImpl();
        MessageListenerImpl msgl = this.stateIdPrefix == null ? null : new MessageListenerImpl();
        this.dispatcher = new RpcHandler(this.scopeId, this.channel, (MessageListener)msgl, (MembershipListener)meml, new RequestMarshallerImpl(), new ResponseMarshallerImpl());
        if (!this.channel.isConnected()) {
            this.channelSelfConnected = true;
            this.channel.connect(this.getGroupName());
            this.log.debug((Object)"Get current members");
            this.waitForView();
        } else {
            meml.viewAccepted(this.channel.getView());
            this.flushBlockGate.open();
        }
        Boolean receiveLocal = (Boolean)this.channel.getOpt(3);
        this.directlyInvokeLocal = receiveLocal != null && receiveLocal == false;
        this.localJGAddress = this.channel.getAddress();
        this.me = this.nodeFactory.getClusterNode(this.localJGAddress);
        this.verifyNodeIsUnique();
        this.asynchHandler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        try {
            this.asynchHandler.stop();
        }
        catch (Exception e) {
            this.log.warn((Object)"Failed to stop asynchHandler", (Throwable)e);
        }
        try {
            if (this.channelSelfConnected && this.channel != null && this.channel.isConnected()) {
                this.channelSelfConnected = false;
                this.channel.disconnect();
                this.channel.close();
            }
        }
        catch (Exception e) {
            this.log.error((Object)"channel disconnection failed", (Throwable)e);
        }
        finally {
            this.channel = null;
        }
    }

    protected void destroyService() {
    }

    protected Channel createChannel() {
        ChannelFactory factory = this.getChannelFactory();
        if (factory == null) {
            throw new IllegalStateException("HAPartitionConfig has no JChannelFactory");
        }
        String stack = this.getChannelStackName();
        if (stack == null) {
            throw new IllegalStateException("HAPartitionConfig has no multiplexer stack");
        }
        try {
            return factory.createChannel(this.getGroupName());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failure creating multiplexed Channel", e);
        }
    }

    protected Channel getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerGroupMembershipListener(GroupMembershipListener listener, boolean sync) {
        if (sync && this.allowSyncListeners) {
            ArrayList<GroupMembershipListener> arrayList = this.syncMembershipListeners;
            synchronized (arrayList) {
                this.syncMembershipListeners.add(listener);
            }
        }
        ArrayList<GroupMembershipListener> arrayList = this.asyncMembershipListeners;
        synchronized (arrayList) {
            this.asyncMembershipListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterGroupMembershipListener(GroupMembershipListener listener, boolean sync) {
        if (sync && this.allowSyncListeners) {
            ArrayList<GroupMembershipListener> arrayList = this.syncMembershipListeners;
            synchronized (arrayList) {
                this.syncMembershipListeners.remove(listener);
            }
        }
        ArrayList<GroupMembershipListener> arrayList = this.asyncMembershipListeners;
        synchronized (arrayList) {
            this.asyncMembershipListeners.remove(listener);
        }
    }

    protected void logHistory(String message) {
        if (this.maxHistoryLength > 0) {
            try {
                this.history.add(new SimpleDateFormat().format(new Date()) + " : " + message);
                if (this.history.size() > this.maxHistoryLength) {
                    this.history.remove(0);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object objectFromByteBufferInternal(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        ContextClassLoaderSwitcher.SwitchContext context = this.classLoaderSwitcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
            Object object = mvis.readObject();
            return object;
        }
        finally {
            context.reset();
        }
    }

    byte[] objectToByteBufferInternal(Object obj) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object objectFromByteBufferResponseInternal(byte[] buffer) throws Exception {
        if (buffer == null) {
            return null;
        }
        if (buffer[0] == 0) {
            return null;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer);
        bais.read();
        ContextClassLoaderSwitcher.SwitchContext context = this.classLoaderSwitcher.getSwitchContext(this.getClass().getClassLoader());
        try {
            MarshalledValueInputStream mvis = new MarshalledValueInputStream((InputStream)bais);
            Object object = mvis.readObject();
            return object;
        }
        finally {
            context.reset();
        }
    }

    byte[] objectToByteBufferResponseInternal(Object obj) throws Exception {
        if (obj == null) {
            return new byte[]{0};
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(1);
        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream((OutputStream)baos);
        mvos.writeObject(obj);
        mvos.flush();
        return baos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyChannelLock() {
        Object object = this.channelLock;
        synchronized (object) {
            this.channelLock.notifyAll();
        }
    }

    private <T> ArrayList<T> processResponseList(RspList rspList, Class<T> returnType, boolean trace) {
        if (returnType == null) {
            Class<Void> unchecked = Void.TYPE;
            returnType = unchecked;
        }
        ArrayList<Object> rtn = new ArrayList<Object>();
        if (rspList != null) {
            for (Rsp response : rspList.values()) {
                if (response.wasReceived()) {
                    Object item = response.getValue();
                    if (item instanceof NoHandlerForRPC || item instanceof NoMuxHandler) continue;
                    rtn.add(returnType.cast(item));
                    continue;
                }
                if (!trace) continue;
                this.log.trace((Object)("Ignoring non-received response: " + response));
            }
        }
        return rtn;
    }

    GroupView processViewChange(View newView) throws Exception {
        GroupView oldMembers = this.groupView;
        GroupView newGroupView = new GroupView(newView, oldMembers, this.nodeFactory);
        this.logHistory("New view: " + newGroupView.allMembers + " with viewId: " + newGroupView.viewId + " (old view: " + newGroupView.allMembers + " )");
        this.groupView = newGroupView;
        if (oldMembers.viewId == -1L) {
            this.log.debug((Object)("ViewAccepted: initial members set for partition " + this.getGroupName() + ": " + newGroupView.viewId + " (" + this.groupView + ")"));
            this.log.info((Object)("Number of cluster members: " + newGroupView.allMembers.size()));
            for (ClusterNode node : newGroupView.allMembers) {
                this.log.debug((Object)node);
            }
            this.notifyChannelLock();
        } else {
            int difference = newGroupView.allMembers.size() - oldMembers.allMembers.size();
            boolean merge = newView instanceof MergeView;
            if (this.isCurrentNodeCoordinator()) {
                this.clusterLifeCycleLog.info((Object)("New cluster view for partition " + this.getGroupName() + " (id: " + newGroupView.viewId + ", delta: " + difference + ", merge: " + merge + ") : " + newGroupView.allMembers));
            } else {
                this.log.info((Object)("New cluster view for partition " + this.getGroupName() + ": " + newGroupView.viewId + " (" + this.groupView + " delta: " + difference + ", merge: " + merge + ")"));
            }
            this.log.debug((Object)("dead members: " + newGroupView.deadMembers));
            this.log.debug((Object)("membership changed from " + oldMembers.allMembers.size() + " to " + newGroupView.allMembers.size()));
            this.asynchHandler.queueEvent(newGroupView);
            if (this.allowSyncListeners) {
                this.notifyListeners(this.syncMembershipListeners, newGroupView.viewId, newGroupView.allMembers, newGroupView.deadMembers, newGroupView.newMembers, newGroupView.originatingGroups);
            }
        }
        return newGroupView;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForView() throws Exception {
        boolean intr = false;
        try {
            Object object = this.channelLock;
            synchronized (object) {
                if (this.getCurrentViewId() == -1L) {
                    try {
                        this.channelLock.wait(this.getMethodCallTimeout());
                    }
                    catch (InterruptedException iex) {
                        intr = true;
                    }
                    if (this.groupView == null) {
                        throw new IllegalStateException("No view received from Channel");
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void setupLoggers(String partitionName) {
        if (partitionName == null) {
            this.log = Logger.getLogger((String)this.getClass().getName());
            this.clusterLifeCycleLog = Logger.getLogger((String)(this.getClass().getName() + ".lifecycle"));
        } else {
            this.log = Logger.getLogger((String)(this.getClass().getName() + "." + partitionName));
            this.clusterLifeCycleLog = Logger.getLogger((String)(this.getClass().getName() + ".lifecycle." + partitionName));
        }
    }

    private void verifyNodeIsUnique() throws IllegalStateException {
        ClusterNodeImpl matched = null;
        for (ClusterNode member : this.getClusterNodes()) {
            if (!member.equals(this.me)) continue;
            if (matched == null) {
                matched = (ClusterNodeImpl)member;
                continue;
            }
            ClusterNodeImpl other = matched;
            if (other.getOriginalJGAddress().equals(((ClusterNodeImpl)this.me).getOriginalJGAddress())) {
                other = (ClusterNodeImpl)member;
            }
            throw new IllegalStateException("Found member " + other + " in current view that duplicates us (" + this.me + "). This" + " node cannot join partition until duplicate member has" + " been removed");
        }
    }

    static Vector<ClusterNode> translateAddresses(Vector<Address> addresses, ClusterNodeFactory factory) {
        if (addresses == null) {
            return null;
        }
        Vector<ClusterNode> result = new Vector<ClusterNode>(addresses.size());
        for (Address address : addresses) {
            result.add(factory.getClusterNode(address));
        }
        return result;
    }

    static Vector<ClusterNode> getDeadMembers(Vector<ClusterNode> oldMembers, Vector<ClusterNode> newMembers) {
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (newMembers == null) {
            newMembers = new Vector();
        }
        Vector<ClusterNode> dead = CoreGroupCommunicationService.cloneMembers(oldMembers);
        dead.removeAll(newMembers);
        return dead;
    }

    static Vector<ClusterNode> getNewMembers(Vector<ClusterNode> oldMembers, Vector<ClusterNode> allMembers) {
        if (oldMembers == null) {
            oldMembers = new Vector();
        }
        if (allMembers == null) {
            allMembers = new Vector();
        }
        Vector<ClusterNode> newMembers = CoreGroupCommunicationService.cloneMembers(allMembers);
        newMembers.removeAll(oldMembers);
        return newMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyListeners(ArrayList<GroupMembershipListener> theListeners, long viewID, Vector<ClusterNode> allMembers, Vector<ClusterNode> deadMembers, Vector<ClusterNode> newMembers, Vector<List<ClusterNode>> originatingGroups) {
        this.log.debug((Object)("Begin notifyListeners, viewID: " + viewID));
        List<GroupMembershipListener> toNotify = null;
        ArrayList<GroupMembershipListener> arrayList = theListeners;
        synchronized (arrayList) {
            toNotify = CoreGroupCommunicationService.cloneListeners(theListeners);
        }
        for (GroupMembershipListener aListener : toNotify) {
            try {
                if (originatingGroups != null) {
                    aListener.membershipChangedDuringMerge(deadMembers, newMembers, allMembers, originatingGroups);
                    continue;
                }
                aListener.membershipChanged(deadMembers, newMembers, allMembers);
            }
            catch (Throwable e) {
                this.log.warn((Object)("Membership listener callback failure: " + aListener), e);
            }
        }
        this.log.debug((Object)("End notifyListeners, viewID: " + viewID));
    }

    static Vector<Address> cloneMembers(View view) {
        return (Vector)view.getMembers().clone();
    }

    private static Vector<ClusterNode> cloneMembers(Vector<ClusterNode> toClone) {
        return (Vector)toClone.clone();
    }

    private static List<GroupMembershipListener> cloneListeners(ArrayList<GroupMembershipListener> toClone) {
        return (List)toClone.clone();
    }

    private class AsynchronousLocalInvocation
    implements Runnable {
        private final String serviceName;
        private final String methodName;
        private final Object[] args;
        private final Class<?>[] types;

        AsynchronousLocalInvocation(String serviceName, String methodName, Object[] args, Class<?>[] types) {
            this.serviceName = serviceName;
            this.methodName = methodName;
            this.args = args;
            this.types = types;
        }

        @Override
        public void run() {
            try {
                CoreGroupCommunicationService.this.invokeDirectly(this.serviceName, this.methodName, this.args, this.types, Void.TYPE, null, null);
            }
            catch (Exception e) {
                CoreGroupCommunicationService.this.log.warn((Object)("Caught exception asynchronously invoking method " + this.methodName + " on service " + this.serviceName), (Throwable)e);
            }
        }

        public void invoke() {
            if (CoreGroupCommunicationService.this.threadPool != null) {
                CoreGroupCommunicationService.this.threadPool.execute(this);
            } else {
                this.run();
            }
        }
    }

    private class StreamStateTransferTask
    extends StateTransferTask<StreamStateTransferResult, InputStream> {
        StreamStateTransferTask(String serviceName) {
            super(serviceName);
        }

        @Override
        protected StreamStateTransferResult createStateTransferResult(final boolean gotState, final InputStream state, final Exception exception) {
            return new StreamStateTransferResult(){

                public InputStream getState() {
                    return state;
                }

                public Exception getStateTransferException() {
                    return exception;
                }

                public boolean stateReceived() {
                    return gotState;
                }
            };
        }

        @Override
        protected void setStateInternal(InputStream is) throws IOException, ClassNotFoundException {
            this.state = is;
        }
    }

    private class SerializableStateTransferTask
    extends StateTransferTask<SerializableStateTransferResult, Serializable> {
        private final WeakReference<ClassLoader> classloader;

        SerializableStateTransferTask(String serviceName, ClassLoader cl) {
            super(serviceName);
            this.classloader = cl != null ? null : new WeakReference<ClassLoader>(cl);
        }

        @Override
        protected SerializableStateTransferResult createStateTransferResult(final boolean gotState, final Serializable state, final Exception exception) {
            return new SerializableStateTransferResult(){

                public Serializable getState() {
                    return state;
                }

                public Exception getStateTransferException() {
                    return exception;
                }

                public boolean stateReceived() {
                    return gotState;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void setStateInternal(InputStream is) throws IOException, ClassNotFoundException {
            ClassLoader cl = this.getStateTransferClassLoader();
            ContextClassLoaderSwitcher.SwitchContext switchContext = CoreGroupCommunicationService.this.classLoaderSwitcher.getSwitchContext(cl);
            try {
                MarshalledValueInputStream mvis = new MarshalledValueInputStream(is);
                this.state = (Serializable)mvis.readObject();
            }
            finally {
                switchContext.reset();
            }
        }

        private ClassLoader getStateTransferClassLoader() {
            ClassLoader cl;
            ClassLoader classLoader = cl = this.classloader == null ? null : (ClassLoader)this.classloader.get();
            if (cl == null) {
                cl = this.getClass().getClassLoader();
            }
            return cl;
        }
    }

    private abstract class StateTransferTask<T extends StateTransferResult, V>
    implements Callable<T> {
        private final String serviceName;
        V state;
        private boolean isStateSet;
        private Exception setStateException;
        T result;
        private final Object callMutex = new Object();

        StateTransferTask(String serviceName) {
            this.serviceName = serviceName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            Object object = this.callMutex;
            synchronized (object) {
                if (this.result != null) {
                    return this.result;
                }
                boolean intr = false;
                boolean rc = false;
                try {
                    this.isStateSet = false;
                    long start = System.currentTimeMillis();
                    String state_id = CoreGroupCommunicationService.this.stateIdPrefix + this.serviceName;
                    rc = CoreGroupCommunicationService.this.getChannel().getState(null, state_id, CoreGroupCommunicationService.this.getStateTransferTimeout());
                    if (rc) {
                        StateTransferTask stateTransferTask = this;
                        synchronized (stateTransferTask) {
                            while (!this.isStateSet) {
                                if (this.setStateException != null) {
                                    throw this.setStateException;
                                }
                                try {
                                    this.wait();
                                }
                                catch (InterruptedException iex) {
                                    intr = true;
                                }
                            }
                        }
                        long stop = System.currentTimeMillis();
                        CoreGroupCommunicationService.this.log.debug((Object)("serviceState was retrieved successfully (in " + (stop - start) + " milliseconds)"));
                    } else {
                        Object object2 = CoreGroupCommunicationService.this.channelLock;
                        synchronized (object2) {
                            while (CoreGroupCommunicationService.this.getCurrentView().size() == 0) {
                                CoreGroupCommunicationService.this.log.debug((Object)"waiting on viewAccepted()");
                                try {
                                    CoreGroupCommunicationService.this.channelLock.wait();
                                }
                                catch (InterruptedException iex) {
                                    intr = true;
                                }
                            }
                        }
                        if (CoreGroupCommunicationService.this.isCurrentNodeCoordinator()) {
                            CoreGroupCommunicationService.this.log.debug((Object)("State could not be retrieved for service " + this.serviceName + " (we are the first member in group)"));
                        } else {
                            throw new IllegalStateException("Initial serviceState transfer failed: Channel.getState() returned false");
                        }
                    }
                    this.result = this.createStateTransferResult(rc, this.state, null);
                }
                catch (Exception e) {
                    this.result = this.createStateTransferResult(rc, null, e);
                }
                finally {
                    if (intr) {
                        Thread.currentThread().interrupt();
                    }
                }
                return this.result;
            }
        }

        protected abstract T createStateTransferResult(boolean var1, V var2, Exception var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setState(byte[] state) {
            Object bais;
            try {
                if (state == null) {
                    CoreGroupCommunicationService.this.log.debug((Object)("transferred state for service " + this.serviceName + " is null (may be first member in cluster)"));
                } else {
                    bais = new ByteArrayInputStream(state);
                    this.setStateInternal((InputStream)bais);
                    ((ByteArrayInputStream)bais).close();
                }
                this.isStateSet = true;
            }
            catch (Throwable t) {
                this.recordSetStateFailure(t);
            }
            finally {
                bais = this;
                synchronized (bais) {
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setState(InputStream state) {
            try {
                if (state == null) {
                    CoreGroupCommunicationService.this.log.debug((Object)("transferred state for service " + this.serviceName + " is null (may be first member in cluster)"));
                } else {
                    this.setStateInternal(state);
                }
                this.isStateSet = true;
            }
            catch (Throwable t) {
                this.recordSetStateFailure(t);
            }
            finally {
                StateTransferTask stateTransferTask = this;
                synchronized (stateTransferTask) {
                    this.notifyAll();
                }
            }
        }

        protected abstract void setStateInternal(InputStream var1) throws IOException, ClassNotFoundException;

        private void recordSetStateFailure(Throwable t) {
            CoreGroupCommunicationService.this.log.error((Object)("failed setting serviceState for service " + this.serviceName), t);
            this.setStateException = t instanceof Exception ? (Exception)t : new Exception(t);
        }
    }

    class MessageListenerImpl
    implements ExtendedMessageListener {
        MessageListenerImpl() {
        }

        public void receive(Message msg) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void getState(String state_id, OutputStream ostream) {
            String serviceName = this.extractServiceName(state_id);
            CoreGroupCommunicationService.this.log.debug((Object)("getState called for service " + serviceName));
            StateTransferProvider provider = CoreGroupCommunicationService.this.stateProviders.get(serviceName);
            if (provider != null) {
                OutputStream toClose = ostream;
                Serializable state = provider.getCurrentState();
                try {
                    if (provider instanceof StateTransferStreamProvider) {
                        ((StateTransferStreamProvider)provider).getCurrentState(ostream);
                    } else {
                        MarshalledValueOutputStream mvos = new MarshalledValueOutputStream(ostream);
                        toClose = mvos;
                        mvos.writeObject((Object)state);
                    }
                }
                catch (Exception ex) {
                    CoreGroupCommunicationService.this.log.error((Object)("getState failed for service " + serviceName), (Throwable)ex);
                }
                finally {
                    if (toClose != null) {
                        try {
                            toClose.flush();
                            toClose.close();
                        }
                        catch (IOException ignored) {
                            CoreGroupCommunicationService.this.log.debug((Object)"Caught exception closing stream used for marshalling state", (Throwable)ignored);
                        }
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getState(String state_id) {
            String serviceName = this.extractServiceName(state_id);
            CoreGroupCommunicationService.this.log.debug((Object)("getState called for service " + serviceName));
            StateTransferProvider provider = CoreGroupCommunicationService.this.stateProviders.get(serviceName);
            if (provider != null) {
                MarshalledValueOutputStream mvos = null;
                Serializable state = provider.getCurrentState();
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                    mvos = new MarshalledValueOutputStream((OutputStream)baos);
                    mvos.writeObject((Object)state);
                    mvos.flush();
                    mvos.close();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                catch (Exception ex) {
                    CoreGroupCommunicationService.this.log.error((Object)("getState failed for service " + serviceName), (Throwable)ex);
                }
                finally {
                    if (mvos != null) {
                        try {
                            mvos.close();
                        }
                        catch (IOException ignored) {
                            CoreGroupCommunicationService.this.log.debug((Object)"Caught exception closing stream used for marshalling state", (Throwable)ignored);
                        }
                    }
                }
            }
            return null;
        }

        public void setState(String state_id, byte[] state) {
            String serviceName = this.extractServiceName(state_id);
            CoreGroupCommunicationService.this.log.debug((Object)("setState called for service " + serviceName));
            StateTransferTask<?, ?> task = CoreGroupCommunicationService.this.stateTransferTasks.remove(serviceName);
            if (task == null) {
                CoreGroupCommunicationService.this.log.warn((Object)("No " + StateTransferTask.class.getSimpleName() + " registered to receive state for service " + serviceName));
            } else {
                task.setState(state);
            }
        }

        public void setState(String state_id, InputStream istream) {
            String serviceName = this.extractServiceName(state_id);
            CoreGroupCommunicationService.this.log.debug((Object)("setState called for service " + serviceName));
            StateTransferTask<?, ?> task = CoreGroupCommunicationService.this.stateTransferTasks.remove(serviceName);
            if (task == null) {
                CoreGroupCommunicationService.this.log.warn((Object)("No " + StateTransferTask.class.getSimpleName() + " registered to receive state for service " + serviceName));
                try {
                    byte[] bytes = new byte[1024];
                    while (istream.read(bytes) >= 0) {
                    }
                }
                catch (IOException ignored) {}
            } else {
                task.setState(istream);
            }
        }

        public byte[] getState() {
            throw new UnsupportedOperationException("Only partial state transfer (with a state_id) is supported");
        }

        public void getState(OutputStream stream) {
            throw new UnsupportedOperationException("Only partial state transfer (with a state_id) is supported");
        }

        public void setState(byte[] obj) {
            throw new UnsupportedOperationException("Only partial state transfer (with a state_id) is supported");
        }

        public void setState(InputStream stream) {
            throw new UnsupportedOperationException("Only partial state transfer (with a state_id) is supported");
        }

        private String extractServiceName(String state_id) {
            if (!state_id.startsWith(CoreGroupCommunicationService.this.stateIdPrefix)) {
                throw new IllegalArgumentException("Unknown state_id " + state_id + " -- must start with " + CoreGroupCommunicationService.this.stateIdPrefix);
            }
            return state_id.substring(CoreGroupCommunicationService.this.stateIdPrefix.length());
        }
    }

    class MembershipListenerImpl
    implements ExtendedMembershipListener {
        MembershipListenerImpl() {
        }

        public void suspect(Address suspected_mbr) {
            CoreGroupCommunicationService.this.logHistory("Node suspected: " + (suspected_mbr == null ? "null" : suspected_mbr.toString()));
            if (CoreGroupCommunicationService.this.isCurrentNodeCoordinator()) {
                CoreGroupCommunicationService.this.clusterLifeCycleLog.info((Object)("Suspected member: " + suspected_mbr));
            } else {
                CoreGroupCommunicationService.this.log.info((Object)("Suspected member: " + suspected_mbr));
            }
        }

        public void block() {
            CoreGroupCommunicationService.this.flushBlockGate.close();
            CoreGroupCommunicationService.this.log.debug((Object)("Block processed at " + CoreGroupCommunicationService.this.me));
        }

        public void unblock() {
            CoreGroupCommunicationService.this.flushBlockGate.open();
            CoreGroupCommunicationService.this.log.debug((Object)("Unblock processed at " + CoreGroupCommunicationService.this.me));
        }

        public void viewAccepted(View newView) {
            try {
                CoreGroupCommunicationService.this.processViewChange(newView);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                CoreGroupCommunicationService.this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
            }
            catch (Exception ex) {
                CoreGroupCommunicationService.this.log.error((Object)"ViewAccepted failed", (Throwable)ex);
            }
        }
    }

    private static class HAServiceResponse
    implements Serializable {
        private static final long serialVersionUID = -6485594652749906437L;
        private final String serviceName;
        private final byte[] payload;

        public HAServiceResponse(String serviceName, byte[] payload) {
            this.serviceName = serviceName;
            this.payload = payload;
        }

        public String getServiceName() {
            return this.serviceName;
        }

        public byte[] getPayload() {
            return this.payload;
        }
    }

    public static class NoHandlerForRPC
    implements Serializable {
        static final long serialVersionUID = -1263095408483622838L;
    }

    class ClusterNodeFactoryImpl
    implements ClusterNodeFactory {
        private final ConcurrentMap<Address, IpAddress> addressMap = new ConcurrentHashMap<Address, IpAddress>();

        ClusterNodeFactoryImpl() {
        }

        @Override
        public ClusterNode getClusterNode(Address a) {
            IpAddress result = (IpAddress)this.addressMap.get(a);
            if (result == null) {
                result = (IpAddress)CoreGroupCommunicationService.this.channel.downcall(new Event(87, (Object)a));
                if (result == null) {
                    throw new IllegalStateException("Address " + a + "not registered in transport layer");
                }
                this.addressMap.put(a, result);
            }
            InetSocketAddress socketAddress = new InetSocketAddress(result.getIpAddress(), result.getPort());
            String id = CoreGroupCommunicationService.this.channel.getName(a);
            if (id == null) {
                id = socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
            }
            return new ClusterNodeImpl(id, a, socketAddress);
        }
    }

    static class ThreadGate {
        private static final int OPEN = 1;
        private static final int CLOSED = -1;
        private final Sync sync = new Sync(-1);

        ThreadGate() {
        }

        public void open() {
            this.sync.releaseShared(1);
        }

        public void close() {
            this.sync.releaseShared(-1);
        }

        public boolean await(long timeout) throws InterruptedException {
            return this.sync.tryAcquireSharedNanos(0, TimeUnit.MILLISECONDS.toNanos(timeout));
        }

        private static class Sync
        extends AbstractQueuedSynchronizer {
            private static final long serialVersionUID = 1L;

            Sync(int state) {
                this.setState(state);
            }

            @Override
            protected int tryAcquireShared(int ingored) {
                return this.getState();
            }

            @Override
            protected boolean tryReleaseShared(int state) {
                this.setState(state);
                return true;
            }
        }
    }

    class ViewChangeEventProcessor
    implements AsynchEventHandler.AsynchEventProcessor {
        ViewChangeEventProcessor() {
        }

        @Override
        public void processEvent(Object event) {
            GroupView vce = (GroupView)event;
            CoreGroupCommunicationService.this.notifyListeners(CoreGroupCommunicationService.this.asyncMembershipListeners, vce.viewId, vce.allMembers, vce.deadMembers, vce.newMembers, vce.originatingGroups);
        }
    }

    private class RpcHandler
    extends MuxRpcDispatcher
    implements StateTransferFilter {
        RpcHandler(short scopeId, Channel channel, MessageListener messageListener, MembershipListener membershipListener, RpcDispatcher.Marshaller reqMarshaller, RpcDispatcher.Marshaller rspMarshaller) {
            super(scopeId);
            this.setMessageListener(messageListener);
            this.setMembershipListener(membershipListener);
            this.setRequestMarshaller(reqMarshaller);
            this.setResponseMarshaller(rspMarshaller);
            this.setChannel(channel);
            channel.addChannelListener((ChannelListener)this);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object handle(Message req) {
            Object body = null;
            Object retval = null;
            Object handler = null;
            boolean trace = this.log.isTraceEnabled();
            String service = null;
            byte[] request_bytes = null;
            if (trace) {
                this.log.trace("Partition " + CoreGroupCommunicationService.this.getGroupName() + " received msg");
            }
            if (req == null || req.getBuffer() == null) {
                this.log.warn("Partition " + CoreGroupCommunicationService.this.getGroupName() + " message or message buffer is null!");
                return null;
            }
            try {
                Object wrapper = CoreGroupCommunicationService.this.objectFromByteBufferInternal(req.getBuffer());
                if (wrapper == null || !(wrapper instanceof Object[])) {
                    this.log.warn("Partition " + CoreGroupCommunicationService.this.getGroupName() + " message wrapper does not contain Object[] object!");
                    return null;
                }
                Object[] temp = (Object[])wrapper;
                service = (String)temp[0];
                request_bytes = (byte[])temp[1];
                handler = CoreGroupCommunicationService.this.rpcHandlers.get(service);
                if (handler == null) {
                    if (trace) {
                        this.log.trace("Partition " + CoreGroupCommunicationService.this.getGroupName() + " no rpc handler registered under service " + service);
                    }
                    return new NoHandlerForRPC();
                }
            }
            catch (Exception e) {
                this.log.warn("Partition " + CoreGroupCommunicationService.this.getGroupName() + " failed unserializing message buffer (msg=" + req + ")", (Throwable)e);
                return null;
            }
            WeakReference<ClassLoader> weak = CoreGroupCommunicationService.this.clmap.get(service);
            ContextClassLoaderSwitcher.SwitchContext context = CoreGroupCommunicationService.this.classLoaderSwitcher.getSwitchContext(weak != null ? (ClassLoader)weak.get() : CoreGroupCommunicationService.class.getClassLoader());
            try {
                body = CoreGroupCommunicationService.this.objectFromByteBufferInternal(request_bytes);
            }
            catch (Exception e) {
                this.log.warn("Partition " + CoreGroupCommunicationService.this.getGroupName() + " failed extracting message body from request bytes", (Throwable)e);
                Object var11_13 = null;
                return var11_13;
            }
            finally {
                context.reset();
            }
            if (body == null || !(body instanceof MethodCall)) {
                this.log.warn("Partition " + CoreGroupCommunicationService.this.getGroupName() + " message does not contain a MethodCall object!");
                return null;
            }
            MethodCall method_call = (MethodCall)body;
            String methodName = method_call.getName();
            if (trace) {
                this.log.trace("full methodName: " + methodName);
            }
            int idx = methodName.lastIndexOf(46);
            String handlerName = methodName.substring(0, idx);
            String newMethodName = methodName.substring(idx + 1);
            if (trace) {
                this.log.trace("handlerName: " + handlerName + " methodName: " + newMethodName);
                this.log.trace("Handle: " + methodName);
            }
            method_call.setName(newMethodName);
            try {
                retval = method_call.invoke(handler);
                if (weak != null) {
                    byte[] retbytes = CoreGroupCommunicationService.this.objectToByteBufferResponseInternal(retval);
                    retval = new HAServiceResponse(handlerName, retbytes);
                }
                if (trace) {
                    this.log.trace("rpc call return value: " + retval);
                }
            }
            catch (Throwable t) {
                if (trace) {
                    this.log.trace("Partition " + CoreGroupCommunicationService.this.getGroupName() + " rpc call threw exception", t);
                }
                retval = t;
            }
            return retval;
        }

        public void start() {
            super.start();
            MuxUpHandler muxer = this.getMuxer();
            if (muxer != null) {
                muxer.add(CoreGroupCommunicationService.this.scopeId.shortValue(), (Object)new DelegatingStateTransferUpHandler(this.getProtocolAdapter(), (StateTransferFilter)this));
            } else {
                muxer = new MuxUpHandler(this.channel.getUpHandler());
                muxer.add(CoreGroupCommunicationService.this.scopeId.shortValue(), (Object)new DelegatingStateTransferUpHandler(this.getProtocolAdapter(), (StateTransferFilter)this));
                this.channel.setUpHandler((UpHandler)muxer);
            }
        }

        public void stop() {
            Muxer<UpHandler> muxer = this.getMuxer();
            if (muxer != null) {
                muxer.remove(CoreGroupCommunicationService.this.scopeId.shortValue());
            }
            super.stop();
        }

        public boolean accepts(String stateId) {
            return stateId != null && stateId.startsWith(CoreGroupCommunicationService.this.stateIdPrefix);
        }

        private Muxer<UpHandler> getMuxer() {
            UpHandler handler = this.channel.getUpHandler();
            return handler != null && handler instanceof Muxer ? (Muxer)handler : null;
        }
    }

    class ResponseMarshallerImpl
    implements RpcDispatcher.Marshaller {
        ResponseMarshallerImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            Object retval = CoreGroupCommunicationService.this.objectFromByteBufferResponseInternal(buf);
            if (!(retval instanceof HAServiceResponse)) {
                return retval;
            }
            String serviceName = ((HAServiceResponse)retval).getServiceName();
            byte[] payload = ((HAServiceResponse)retval).getPayload();
            WeakReference<ClassLoader> weak = CoreGroupCommunicationService.this.clmap.get(serviceName);
            ContextClassLoaderSwitcher.SwitchContext context = CoreGroupCommunicationService.this.classLoaderSwitcher.getSwitchContext(weak != null ? (ClassLoader)weak.get() : CoreGroupCommunicationService.class.getClassLoader());
            try {
                Object object = retval = CoreGroupCommunicationService.this.objectFromByteBufferResponseInternal(payload);
                return object;
            }
            finally {
                context.reset();
            }
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            return CoreGroupCommunicationService.this.objectToByteBufferResponseInternal(obj);
        }
    }

    class RequestMarshallerImpl
    implements RpcDispatcher.Marshaller {
        RequestMarshallerImpl() {
        }

        public Object objectFromByteBuffer(byte[] buf) throws Exception {
            return CoreGroupCommunicationService.this.objectFromByteBufferInternal(buf);
        }

        public byte[] objectToByteBuffer(Object obj) throws Exception {
            if (obj instanceof MethodCall) {
                String name = ((MethodCall)obj).getName();
                int idx = name.lastIndexOf(46);
                String serviceName = name.substring(0, idx);
                return CoreGroupCommunicationService.this.objectToByteBufferInternal(new Object[]{serviceName, CoreGroupCommunicationService.this.objectToByteBufferInternal(obj)});
            }
            return CoreGroupCommunicationService.this.objectToByteBufferInternal(obj);
        }
    }

    protected static class GroupView {
        protected final long viewId;
        protected final Vector<ClusterNode> deadMembers;
        protected final Vector<ClusterNode> newMembers;
        protected final Vector<ClusterNode> allMembers;
        protected final Vector<List<ClusterNode>> originatingGroups;
        protected final Vector<Address> jgmembers;
        protected final Address coordinator;

        GroupView() {
            this.viewId = -1L;
            this.deadMembers = new Vector();
            this.allMembers = new Vector();
            this.newMembers = this.allMembers;
            this.jgmembers = new Vector();
            this.coordinator = null;
            this.originatingGroups = null;
        }

        GroupView(View newView, GroupView previousView, ClusterNodeFactory factory) {
            this.viewId = newView.getVid().getId();
            this.jgmembers = CoreGroupCommunicationService.cloneMembers(newView);
            this.coordinator = this.jgmembers.size() == 0 ? null : this.jgmembers.elementAt(0);
            this.allMembers = CoreGroupCommunicationService.translateAddresses(newView.getMembers(), factory);
            this.deadMembers = CoreGroupCommunicationService.getDeadMembers(previousView.allMembers, this.allMembers);
            this.newMembers = CoreGroupCommunicationService.getNewMembers(previousView.allMembers, this.allMembers);
            if (newView instanceof MergeView) {
                MergeView mergeView = (MergeView)newView;
                Vector subgroups = mergeView.getSubgroups();
                this.originatingGroups = new Vector(subgroups.size());
                for (View view : subgroups) {
                    this.originatingGroups.add(CoreGroupCommunicationService.translateAddresses(view.getMembers(), factory));
                }
            } else {
                this.originatingGroups = null;
            }
        }
    }

    private static enum State {
        STOPPED,
        STOPPING,
        STARTING,
        STARTED,
        FAILED,
        DESTROYED,
        CREATED,
        UNREGISTERED;


        public String toString() {
            return this.name().substring(0, 1) + this.name().substring(1).toLowerCase(Locale.US);
        }
    }
}

